#!/usr/bin/ruby -Ku
#
# mmon
#
# Copyright (c) 2007 sanpo
#
# This program is free software.
# You can redistribute it and/or modify it under the terms of the GPL.

require 'mmon/item'
require 'mmon/util'

class ItemDClock < Item
    include Math

    NAME = 'Digital Clock'

    def initialize(parent = nil)
        super(parent)

        @interval = 2.0
        @use_bg = true
        self.set_item_size(72, 32)

        @now = Time.now
    end

    private

    def render_mask(cc, w, h)
        Util.simple_bg(cc, w, h)
        Util.simple_fg(cc, w, h)
    end

    def render_bg(cc, w, h)
        Util.simple_bg(cc, w, h)
        Util.simple_fg(cc, w, h)
    end

    def render(cc, w, h)
        text = @now.strftime('%H:%M') 

#        cc.select_font_face("Sans", Cairo::FONT_SLANT_NORMAL, Cairo::FONT_WEIGHT_BOLD);
        cc.select_font_face("Bitstream Vera Sans", Cairo::FONT_SLANT_NORMAL, Cairo::FONT_WEIGHT_BOLD);
        cc.set_source_rgba(1.0, 1.0, 0.0, 1.0);
        cc.set_font_size(h * 0.5)

        extents = cc.text_extents(text)

        x = w / 2.0 - (extents.width / 2.0) - (extents.x_bearing / 2.0)
        y = h / 2.0 + extents.height / 2.0
    
        cc.move_to(x, y)
        cc.show_text(text);
    end

    def prepare
        old = @now
        @now = Time.now
        
        if @now.min == old.min
            return false
        else
            return true
        end
    end
end

if __FILE__ == $0
    item = ItemDClock.new
    item.show

    Gtk::main()
end
