# mmon
#
# Copyright (c) 2007 sanpo
#
# This program is free software.
# You can redistribute it and/or modify it under the terms of the GPL.

=begin

/proc/meminfo のサンプル

MemTotal:       776344 kB
MemFree:        370248 kB
Buffers:         31240 kB
Cached:         175584 kB
SwapCached:          0 kB
Active:         266012 kB
Inactive:       116104 kB
HighTotal:           0 kB
HighFree:            0 kB
LowTotal:       776344 kB
LowFree:        370248 kB
SwapTotal:      987956 kB
SwapFree:       987956 kB
Dirty:               8 kB
Writeback:           0 kB
AnonPages:      175312 kB
Mapped:          51732 kB
Slab:            13540 kB
PageTables:       1304 kB
NFS_Unstable:        0 kB
Bounce:              0 kB
CommitLimit:   1376128 kB
Committed_AS:   341848 kB
VmallocTotal:   253912 kB
VmallocUsed:     23108 kB
VmallocChunk:   226772 kB

=end

class Memory
    attr_reader :mem_total, :mem_free, :mem_buffers, :mem_cached
    attr_reader :swap_total, :swap_free
    attr_reader :mem_used, :swap_paged

    def initialize
        @mem_total = 0
        @mem_free = 0
        @mem_buffers = 0
        @mem_cached = 0

        @swap_total = 0
        @swap_free = 0

        @mem_used = 0
        @swap_paged = 0

        read()
    end

    REG_TOTAL = /^MemTotal:\s+(\d+) kB/
    REG_FREE = /^MemFree:\s+(\d+) kB/
    REG_BUFFERS = /^Buffers:\s+(\d+) kB/ 
    REG_CACHED = /^Cached:\s+(\d+) kB/
    REG_STOTAL = /^SwapTotal:\s+(\d+) kB/
    REG_SFREE = /^SwapFree:\s+(\d+) kB/ 

    def read
        begin
            f = File.open('/proc/meminfo')
            f.each_line do |l|
                case l
                when REG_TOTAL then @mem_total = $1.to_i
                when REG_FREE  then @mem_free = $1.to_i
                when REG_BUFFERS then @mem_buffers = $1.to_i
                when REG_CACHED  then @mem_cached = $1.to_i
                when REG_STOTAL  then @swap_total = $1.to_i
                when REG_SFREE   then @swap_free = $1.to_i
                end
            end
            
        rescue
            p $!
        ensure 
            f.close
        end

        @mem_used = @mem_total - @mem_free - @mem_buffers - @mem_cached
        @swap_paged = @swap_total - @swap_free
    end

    def print
        puts "memory"
        puts "total  :#{@mem_total}"
        puts "used   :#{@mem_used}"
        puts "free   :#{@mem_free}"
        puts "buffers:#{@mem_buffers}"
        puts "cached :#{@mem_cached}"
        puts "swap"
        puts "total  :#{@swap_total}"
        puts "paged  :#{@swap_paged}"
        puts "free   :#{@swap_free}"
    end
end

if __FILE__ == $0
    mem = Memory.new
    mem.read
    mem.print
end
