# mmon
#
# Copyright (c) 2007 sanpo
#
# This program is free software.
# You can redistribute it and/or modify it under the terms of the GPL.

require 'logger'
require 'singleton'

class MLogger
    include Singleton

    def initialize(dev = STDOUT)
        @logger = new_logger(dev, Logger::DEBUG)
    end

    def debug(str)
        @logger.debug(str)
    end

    def debug=(bool)
        if bool
            @loggerlevel = Logger::DEBUG
        else
            @loggerlevel = Logger::WARN
        end
    end

    def level=(l)
        @logger.level = l
    end

    def logdev=(dev)
        level = @logger.level
        @logger = new_logger(dev, level)
    end

    private

    def new_logger(dev, level)
        logger = Logger.new(dev)
        logger.level = level
        logger.datetime_format = "%H:%M:%S "

        logger
    end
end
