#!/usr/bin/ruby -Ku
#
# mmon
#
# Copyright (c) 2007 sanpo
#
# This program is free software.
# You can redistribute it and/or modify it under the terms of the GPL.

require 'mmon/item'
require 'mmon/util'
require 'mmon/component/label'

class ItemDClock < Item
    NAME = 'Digital Clock'

    @@color_text = Color.new(1.0, 1.0, 0.0, 1.0)

    def initialize(mmon)
        super(mmon)

        @interval = 2.0
        @use_bg = true

        @width = 72
        @height = 32

        @now = Time.now

        @label = Label.new(nil, 16, false, true, @@color_text, 0.5 * @width, 0.5 * @height)
        @label.text = @now.strftime('%H:%M') 
    end

    private

    def render_mask(cc, w, h)
        Util.simple_bg(cc, w, h)
        Util.simple_fg(cc, w, h)
    end

    def render_bg(cc, w, h)
        Util.simple_bg(cc, w, h)
        Util.simple_fg(cc, w, h)
    end

    def render(cc, w, h)
        @label.render(cc)
    end

    def prepare
        old = @now
        @now = Time.now
        
        if @now.min == old.min
            return false
        else
            @label.text = @now.strftime('%H:%M') 
            return true
        end
    end
end

if __FILE__ == $0
    require 'mmon/appmmon'

    app = AppMmon.new
    item = ItemDClock.new(app)
    app.add_item(item)

    Gtk::main()
end
