# mmon
#
# Copyright (c) 2007 sanpo
#
# This program is free software.
# You can redistribute it and/or modify it under the terms of the GPL.

require 'gtk2'

class TrayManager
    def initialize
        @invisible = nil
        @selction_atom = nil
        @orientation_atom = nil
    end

    def manage(widget)
        screen = widget.screen
        window = widget.window

        @invisible = Gtk::Invisible.new(screen)
        @invisible.realize
        @invisible.add_events(Gdk::Event::Mask::PROPERTY_CHANGE_MASK |
                                Gdk::Event::Mask::STRUCTURE_MASK)

        selection_atom_name = '_NET_SYSTEM_TRAY_S' + screen.number
        p selection_atom_name

        @selection_atom = Gdk::Atom.intern(selction_atom_name, false)
        @orientation_atom = Gdk::Atom.intern('_NET_SYSTEM_TRAY_ORIENTATION', false)

        change_orientation_property()

        timestamp = window.server_time
        unless Gdk::Selection.owner_set(@invisible.window, @selection_atom, timestamp, false)
            puts 'owner_get fail'
        end

        if Gdk::Selection.owner_get(@selection_atom) == @invisible.window
            event = Gdk::EventClient.new
            event.message_type = Gdk::Atom.intern('MANAGER', false)

            event.send_client_message_toall
            

        end



        
    end

    def change_orientation_property
        Gdk::Property.change()
    end
