# mmon
#
# Copyright (c) 2007 sanpo
#
# This program is free software.
# You can redistribute it and/or modify it under the terms of the GPL.

require 'mmon/color'

class Label
    ALIGN_CENTER = 0

    @@default_font = 'Bitstream Vera Sans'

    def initialize(font_name = nil, size = 12, italic = false, bold = false, 
            color = nil, x = 0, y = 0, align = ALIGN_CENTER)
        @text = '??'

        @font_name = @@default_font
        @size = 12
        @slant = Cairo::FONT_SLANT_NORMAL
        @weight = Cairo::FONT_WEIGHT_NORMAL

        @color = Color.new(1.0, 1.0, 1.0, 1.0)

        @align = ALIGN_CENTER

        @x_pos = 0 
        @y_pos = 0 

        @initialized = false
        @x = 0 
        @y = 0 

        self.font_name = font_name
        self.font_size = size
        self.italic = italic
        self.bold = bold
        self.color = color
        self.position(x, y)
        self.align = align
    end

    def text=(str)
        @text = str
        @initialized = false
    end

    def font_name=(str)
        if str.nil?
            @font_name = @@default_font
        else
            @font_name = str
        end
        @initialized = false
    end

    def font_size=(size)
        @size = size
        @initialized = false
    end

    def italic=(bool)
        if bool
            @slant = Cairo::FONT_SLANT_ITALIC
        else
            @slant = Cairo::FONT_SLANT_NORMAL
        end
        @initialized = false
    end

    def bold=(bool)
        if bool
            @weight = Cairo::FONT_WEIGHT_BOLD
        else
            @weight = Cairo::FONT_WEIGHT_NORMAL
        end
        @initialized = false
    end

    def font(name, size, italic, bold)
        self.font_name = name
        self.font_size = size
        self.italic = italic
        self.bold = bold
    end

    def color=(color)
        unless color.nil?
            @color = color
        end
    end

    def align=(align)
        @align = align

        @initialized = false
    end

    def position(x_pos, y_pos)
        @x_pos = x_pos
        @y_pos = y_pos

        @initialized = false
    end

    def render(cc)
        cc.select_font_face(@font_name, @slant, @weight);
        cc.set_source_rgba(@color)
        cc.set_font_size(@size)

        unless @initialized
            extents = cc.text_extents(@text)
            case @align
            when ALIGN_CENTER then @x , @y = align_center(extents, @x_pos, @y_pos)
            end
            @initialized = true
        end

        cc.move_to(@x, @y)
        cc.show_text(@text);
    end

    private

    # text_extents な文字列の中央を (x0, y0) にする文字列の左下座標を返す
    def align_center(extents, x0, y0)
        x_bearing = extents.x_bearing
        y_bearing = extents.y_bearing
        width     = extents.width
        height    = extents.height
        x_advance = extents.x_advance
        y_advance = extents.y_advance


        x = x0 - x_bearing - width / 2.0
        y = y0 - y_bearing - height / 2.0

#        show_extents(extents)
#        puts "(x0, y0)  (#{x0}, #{y0})"
#        puts "(x, y)    (#{x}, #{y})"
        
        [x, y]
    end

    # text_extents な文字列の左下を (x0, y0) にする文字列の左下座標を返す
    def align_left(extents, x0, y0)
        x_bearing = extents.x_bearing
        y_bearing = extents.y_bearing
        width     = extents.width
        height    = extents.height
        x_advance = extents.x_advance
        y_advance = extents.y_advance

        x = x0 + x_bearing
        y = y0

#        show_extents(extents)
#        puts "(x0, y0)  (#{x0}, #{y0})"
#        puts "(x, y)    (#{x}, #{y})"
        
        [x, y]
    end

    def show_extents(extents)
        puts 'x_bearing ' + extents.x_bearing.to_s
        puts 'y_bearing ' + extents.y_bearing.to_s
        puts 'width     ' + extents.width.to_s
        puts 'height    ' + extents.height.to_s
        puts 'x_advance ' + extents.x_advance.to_s
        puts 'y_advance ' + extents.y_advance.to_s
    end
end
