# mmon
#
# Copyright (c) 2007 sanpo
#
# This program is free software.
# You can redistribute it and/or modify it under the terms of the GPL.

require 'gtk2'

class TrendGraph
    def initialize(w, h)
        @x = 0
        @y = 0
        @w = w
        @h = h

        @color = nil

        @surface0 = create_surface(@w, @h)
        @surface1 = create_surface(@w, @h)
    end

    def position(x, y)
        @x = x
        @y = y
    end

    def size(w, h)
        @w = w
        @h = h
        @surface = create_surface(@w, @h)
    end

    def color(*color)
        @color = color
    end

    def value(*value)
        if @current_surface == 0
            target = @surface0
            cc = Cairo::Context.new(@surface1)
            @current_surface = 1
        else
            target = @surface1
            cc = Cairo::Context.new(@surface0)
            @current_surface = 0
        end

        cc.antialias = Cairo::ANTIALIAS_NONE
        cc.operator = Cairo::OPERATOR_SOURCE
        cc.set_source(target, -1, 0)
        cc.paint

        cc.set_line_width(1)

        x = @w
        y = @h

        value.size.times do |n|
#            puts "x:#{x} y:#{y}"

            y1 = (value[n] * @h).to_i

            if @color.nil? || @color[n].nil?
                cc.set_source_rgba(1.0, 1.0, 1.0, 1.0)
            else
                cc.set_source_rgba(@color[n])
            end
            cc.move_to(x, y)
            cc.line_to(x, y - y1)
            cc.stroke

            y -= y1
        end
    end

    def render(cc)
        if @current_surface == 0
            surface = @surface0
        else
            surface = @surface1
        end
        cc.set_source(surface, @x, @y)
        cc.paint
    end

    private

    def create_surface(w, h)
        surface = Cairo::ImageSurface.new(Cairo::FORMAT_ARGB32, w, h)

        cc = Cairo::Context.new(surface)
        cc.operator = Cairo::OPERATOR_CLEAR
        cc.paint

        return surface
    end
end

if __FILE__ == $0

end
