#!/usr/bin/ruby
#
# mmon
#
# Copyright (c) 2007 sanpo
#
# This program is free software.
# You can redistribute it and/or modify it under the terms of the GPL.

require 'gtk2'

class CairoWindow < Gtk::Window
    def initialize
        super(Gtk::Window::TOPLEVEL)

        @width = 300 
        @height =300 

        self.decorated = true
        self.set_default_size(@width, @height)
        self.add_events(Gdk::Event::Mask::KEY_PRESS_MASK)

        signal_connect("destroy")          { |w, e| cw_destroy(e) }
        signal_connect("expose-event")     { |w, e| cw_expose(e) }
        signal_connect("key-press-event")  { |w, e| cw_key_press(e) }
    end

    def cw_destroy(event)
        Gtk::main_quit
        true
    end

    def cw_expose(event)
        puts "draw w:#{@width} h:#{@height}"

        cc = self.window.create_cairo_context
        draw(cc, @width, @height)

        true
    end

    def cw_key_press(event)
        if event.keyval == Gdk::Keyval::GDK_Escape
            self.destroy
            true
        else
            false
        end
    end

    def draw(cc, w, h)
=begin
        cc.operator = Cairo::OPERATOR_CLEAR
        cc.paint

        cc.operator = Cairo::OPERATOR_OVER
=end
    end
end
    
if __FILE__ == $0
    unless Gdk.cairo_available?
        puts 'cairo :: not available'
        exit
    end

    window = CairoWindow.new
    window.show

    Gtk::main()
end
