/*
 * Decompiled with CFR 0.152.
 */
package com.jme.input;

import com.jme.input.InputHandler;
import com.jme.input.KeyBindingManager;
import com.jme.input.RelativeMouse;
import com.jme.input.action.InputActionInterface;
import com.jme.input.action.KeyNodeBackwardAction;
import com.jme.input.action.KeyNodeForwardAction;
import com.jme.input.action.KeyNodeLookDownAction;
import com.jme.input.action.KeyNodeLookUpAction;
import com.jme.input.action.KeyNodeRotateLeftAction;
import com.jme.input.action.KeyNodeRotateRightAction;
import com.jme.input.action.KeyNodeStrafeLeftAction;
import com.jme.input.action.KeyNodeStrafeRightAction;
import com.jme.input.action.NodeMouseLook;
import com.jme.math.Vector3f;
import com.jme.scene.Spatial;

public class NodeHandler
extends InputHandler {
    public NodeHandler(Spatial spatial, String string) {
        this.setKeyBindings();
        this.setUpMouse(spatial, 1.0f);
        this.setActions(spatial, 0.5f, 0.01f);
    }

    public NodeHandler(Spatial spatial, float f, float f2) {
        this.setKeyBindings();
        this.setUpMouse(spatial, f2);
        this.setActions(spatial, f, f2);
    }

    private void setKeyBindings() {
        KeyBindingManager keyBindingManager = KeyBindingManager.getKeyBindingManager();
        keyBindingManager.set("forward", 17);
        keyBindingManager.set("backward", 31);
        keyBindingManager.set("strafeLeft", 30);
        keyBindingManager.set("strafeRight", 32);
        keyBindingManager.set("lookUp", 200);
        keyBindingManager.set("lookDown", 208);
        keyBindingManager.set("turnRight", 205);
        keyBindingManager.set("turnLeft", 203);
    }

    private void setUpMouse(Spatial spatial, float f) {
        RelativeMouse relativeMouse = new RelativeMouse("Mouse Input");
        relativeMouse.registerWithInputHandler(this);
        NodeMouseLook nodeMouseLook = new NodeMouseLook(relativeMouse, spatial, 0.1f);
        nodeMouseLook.setSpeed(f);
        nodeMouseLook.setLockAxis(new Vector3f(spatial.getLocalRotation().getRotationColumn((int)1).x, spatial.getLocalRotation().getRotationColumn((int)1).y, spatial.getLocalRotation().getRotationColumn((int)1).z));
        this.addAction(nodeMouseLook);
    }

    private void setActions(Spatial spatial, float f, float f2) {
        this.addAction((InputActionInterface)new KeyNodeForwardAction(spatial, f), "forward", true);
        this.addAction((InputActionInterface)new KeyNodeBackwardAction(spatial, f), "backward", true);
        this.addAction((InputActionInterface)new KeyNodeStrafeLeftAction(spatial, f), "strafeLeft", true);
        this.addAction((InputActionInterface)new KeyNodeStrafeRightAction(spatial, f), "strafeRight", true);
        this.addAction((InputActionInterface)new KeyNodeLookUpAction(spatial, f2), "lookUp", true);
        this.addAction((InputActionInterface)new KeyNodeLookDownAction(spatial, f2), "lookDown", true);
        KeyNodeRotateRightAction keyNodeRotateRightAction = new KeyNodeRotateRightAction(spatial, f2);
        keyNodeRotateRightAction.setLockAxis(spatial.getLocalRotation().getRotationColumn(1));
        this.addAction((InputActionInterface)keyNodeRotateRightAction, "turnRight", true);
        KeyNodeRotateLeftAction keyNodeRotateLeftAction = new KeyNodeRotateLeftAction(spatial, f2);
        keyNodeRotateLeftAction.setLockAxis(spatial.getLocalRotation().getRotationColumn(1));
        this.addAction((InputActionInterface)keyNodeRotateLeftAction, "turnLeft", true);
    }
}

