/*
 * Decompiled with CFR 0.152.
 */
package com.jme.input.action;

import com.jme.input.Mouse;
import com.jme.input.MouseInput;
import com.jme.input.action.InputActionEvent;
import com.jme.input.action.KeyLookDownAction;
import com.jme.input.action.KeyLookUpAction;
import com.jme.input.action.KeyRotateLeftAction;
import com.jme.input.action.KeyRotateRightAction;
import com.jme.input.action.MouseInputAction;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;

public class MouseLook
extends MouseInputAction {
    private KeyLookDownAction lookDown;
    private KeyLookUpAction lookUp;
    private KeyRotateLeftAction rotateLeft;
    private KeyRotateRightAction rotateRight;
    private Vector3f lockAxis;
    private InputActionEvent event;
    private boolean buttonPressRequired = false;

    public MouseLook(Mouse mouse, Camera camera, float f) {
        this.mouse = mouse;
        this.speed = f;
        this.lookDown = new KeyLookDownAction(camera, f);
        this.lookUp = new KeyLookUpAction(camera, f);
        this.rotateLeft = new KeyRotateLeftAction(camera, f);
        this.rotateRight = new KeyRotateRightAction(camera, f);
        this.event = new InputActionEvent();
    }

    public void setLockAxis(Vector3f vector3f) {
        this.lockAxis = vector3f;
        this.rotateLeft.setLockAxis(vector3f);
        this.rotateRight.setLockAxis(vector3f);
    }

    public Vector3f getLockAxis() {
        return this.lockAxis;
    }

    public void setSpeed(float f) {
        super.setSpeed(f);
        this.lookDown.setSpeed(f);
        this.lookUp.setSpeed(f);
        this.rotateRight.setSpeed(f);
        this.rotateLeft.setSpeed(f);
    }

    public void performAction(InputActionEvent inputActionEvent) {
        float f = 0.01f * this.speed;
        if (!this.buttonPressRequired || MouseInput.get().isButtonDown(0)) {
            if (this.mouse.getLocalTranslation().x > 0.0f) {
                this.event.setTime(f * this.mouse.getLocalTranslation().x);
                this.rotateRight.performAction(this.event);
            } else if (this.mouse.getLocalTranslation().x < 0.0f) {
                this.event.setTime(f * this.mouse.getLocalTranslation().x * -1.0f);
                this.rotateLeft.performAction(this.event);
            }
            if (this.mouse.getLocalTranslation().y > 0.0f) {
                this.event.setTime(f * this.mouse.getLocalTranslation().y);
                this.lookUp.performAction(this.event);
            } else if (this.mouse.getLocalTranslation().y < 0.0f) {
                this.event.setTime(f * this.mouse.getLocalTranslation().y * -1.0f);
                this.lookDown.performAction(this.event);
            }
        }
    }

    public boolean isButtonPressRequired() {
        return this.buttonPressRequired;
    }

    public void setButtonPressRequired(boolean bl) {
        this.buttonPressRequired = bl;
    }
}

