/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.state.lwjgl;

import com.jme.light.DirectionalLight;
import com.jme.light.Light;
import com.jme.light.PointLight;
import com.jme.light.SpotLight;
import com.jme.renderer.RenderContext;
import com.jme.scene.SceneElement;
import com.jme.scene.state.LightState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.lwjgl.records.LightRecord;
import com.jme.scene.state.lwjgl.records.LightStateRecord;
import com.jme.scene.state.lwjgl.records.StateRecord;
import com.jme.system.DisplaySystem;
import java.nio.FloatBuffer;
import java.util.Stack;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

public class LWJGLLightState
extends LightState {
    private static final long serialVersionUID = 1L;

    public void apply() {
        RenderContext renderContext = DisplaySystem.getDisplaySystem().getCurrentContext();
        LightStateRecord lightStateRecord = (LightStateRecord)renderContext.getStateRecord(3);
        renderContext.currentStates[3] = this;
        if (this.isEnabled() && LIGHTS_ENABLED) {
            int n;
            this.setLightEnabled(true, lightStateRecord);
            this.setTwoSided(this.twoSidedOn, lightStateRecord);
            this.setLocalViewer(this.localViewerOn, lightStateRecord);
            if (GLContext.getCapabilities().OpenGL12) {
                this.setSpecularControl(this.separateSpecularOn, lightStateRecord);
            }
            int n2 = this.getQuantity();
            for (n = 0; n < n2; ++n) {
                Light light = this.get(n);
                LightRecord lightRecord = lightStateRecord.getLightRecord(n);
                if (lightRecord == null) {
                    lightRecord = new LightRecord();
                    lightStateRecord.setLightRecord(lightRecord, n);
                }
                if (light == null) {
                    this.setSingleLightEnabled(false, n, lightStateRecord, lightRecord);
                    continue;
                }
                if (light.isEnabled()) {
                    this.setLight(n, light, lightStateRecord, lightRecord);
                    continue;
                }
                this.setSingleLightEnabled(false, n, lightStateRecord, lightRecord);
            }
            for (n = this.getQuantity(); n < 8; ++n) {
                LightRecord lightRecord = lightStateRecord.getLightRecord(n);
                if (lightRecord == null) {
                    lightRecord = new LightRecord();
                    lightStateRecord.setLightRecord(lightRecord, n);
                }
                this.setSingleLightEnabled(false, n, lightStateRecord, lightRecord);
            }
            if ((this.lightMask & 8) == 0) {
                this.setModelAmbient(lightStateRecord, this.globalAmbient[0], this.globalAmbient[1], this.globalAmbient[2], this.globalAmbient[3]);
            } else {
                this.setDefaultModelAmbient(lightStateRecord);
            }
        } else {
            this.setLightEnabled(false, lightStateRecord);
        }
        if (!lightStateRecord.isValid()) {
            lightStateRecord.validate();
        }
    }

    private void setLight(int n, Light light, LightStateRecord lightStateRecord, LightRecord lightRecord) {
        Light light2;
        this.setSingleLightEnabled(true, n, lightStateRecord, lightRecord);
        if ((this.lightMask & 1) == 0 && (light.getLightMask() & 1) == 0) {
            this.setAmbient(n, lightStateRecord, light.getAmbient().r, light.getAmbient().g, light.getAmbient().b, light.getAmbient().a, lightRecord);
        } else {
            this.setDefaultAmbient(n, lightStateRecord, lightRecord);
        }
        if ((this.lightMask & 2) == 0 && (light.getLightMask() & 2) == 0) {
            this.setDiffuse(n, lightStateRecord, light.getDiffuse().r, light.getDiffuse().g, light.getDiffuse().b, light.getDiffuse().a, lightRecord);
        } else {
            this.setDefaultDiffuse(n, lightStateRecord, lightRecord);
        }
        if ((this.lightMask & 4) == 0 && (light.getLightMask() & 4) == 0) {
            this.setSpecular(n, lightStateRecord, light.getSpecular().r, light.getSpecular().g, light.getSpecular().b, light.getSpecular().a, lightRecord);
        } else {
            this.setDefaultSpecular(n, lightStateRecord, lightRecord);
        }
        if (light.isAttenuate()) {
            this.setAttenuate(true, n, light, lightStateRecord, lightRecord);
        } else {
            this.setAttenuate(false, n, light, lightStateRecord, lightRecord);
        }
        switch (light.getType()) {
            case 0: {
                light2 = (DirectionalLight)light;
                this.setPosition(n, lightStateRecord, -((DirectionalLight)light2).getDirection().x, -((DirectionalLight)light2).getDirection().y, -((DirectionalLight)light2).getDirection().z, 0.0f, lightRecord);
                break;
            }
            case 1: 
            case 2: {
                light2 = (PointLight)light;
                this.setPosition(n, lightStateRecord, ((PointLight)light2).getLocation().x, ((PointLight)light2).getLocation().y, ((PointLight)light2).getLocation().z, 1.0f, lightRecord);
                break;
            }
        }
        if (light.getType() == 2) {
            light2 = (SpotLight)light;
            this.setSpotCutoff(n, lightStateRecord, ((SpotLight)light2).getAngle(), lightRecord);
            this.setSpotDirection(n, lightStateRecord, ((SpotLight)light2).getDirection().x, ((SpotLight)light2).getDirection().y, ((SpotLight)light2).getDirection().z, 0.0f, lightRecord);
            this.setSpotExponent(n, lightStateRecord, ((SpotLight)light2).getExponent(), lightRecord);
        } else {
            this.setSpotCutoff(n, lightStateRecord, 180.0f, lightRecord);
        }
    }

    private void setSingleLightEnabled(boolean bl, int n, LightStateRecord lightStateRecord, LightRecord lightRecord) {
        if (!lightStateRecord.isValid() || lightRecord.isEnabled() != bl) {
            if (bl) {
                GL11.glEnable((int)(16384 + n));
            } else {
                GL11.glDisable((int)(16384 + n));
            }
            lightRecord.setEnabled(bl);
        }
    }

    private void setLightEnabled(boolean bl, LightStateRecord lightStateRecord) {
        if (!lightStateRecord.isValid() || lightStateRecord.isEnabled() != bl) {
            if (bl) {
                GL11.glEnable((int)2896);
            } else {
                GL11.glDisable((int)2896);
            }
            lightStateRecord.setEnabled(bl);
        }
    }

    private void setTwoSided(boolean bl, LightStateRecord lightStateRecord) {
        if (!lightStateRecord.isValid() || lightStateRecord.isTwoSidedOn() != bl) {
            if (bl) {
                GL11.glLightModeli((int)2898, (int)1);
            } else {
                GL11.glLightModeli((int)2898, (int)0);
            }
            lightStateRecord.setTwoSidedOn(bl);
        }
    }

    private void setLocalViewer(boolean bl, LightStateRecord lightStateRecord) {
        if (!lightStateRecord.isValid() || lightStateRecord.isLocalViewer() != bl) {
            if (bl) {
                GL11.glLightModeli((int)2897, (int)1);
            } else {
                GL11.glLightModeli((int)2897, (int)0);
            }
            lightStateRecord.setLocalViewer(bl);
        }
    }

    private void setSpecularControl(boolean bl, LightStateRecord lightStateRecord) {
        if (!lightStateRecord.isValid() || lightStateRecord.isSeparateSpecular() != bl) {
            if (bl) {
                GL11.glLightModeli((int)33272, (int)33274);
            } else {
                GL11.glLightModeli((int)33272, (int)33273);
            }
            lightStateRecord.setSeparateSpecular(bl);
        }
    }

    private void setModelAmbient(LightStateRecord lightStateRecord, float f, float f2, float f3, float f4) {
        if (!lightStateRecord.isValid() || lightStateRecord.globalAmbient.r != f || lightStateRecord.globalAmbient.g != f2 || lightStateRecord.globalAmbient.b != f3 || lightStateRecord.globalAmbient.a != f4) {
            lightStateRecord.lightBuffer.clear();
            lightStateRecord.lightBuffer.put(f);
            lightStateRecord.lightBuffer.put(f2);
            lightStateRecord.lightBuffer.put(f3);
            lightStateRecord.lightBuffer.put(f4);
            lightStateRecord.lightBuffer.flip();
            GL11.glLightModel((int)2899, (FloatBuffer)lightStateRecord.lightBuffer);
            lightStateRecord.globalAmbient.set(f, f2, f3, f4);
        }
    }

    private void setDefaultModelAmbient(LightStateRecord lightStateRecord) {
        if (!lightStateRecord.isValid() || lightStateRecord.globalAmbient.r != 0.0f || lightStateRecord.globalAmbient.g != 0.0f || lightStateRecord.globalAmbient.b != 0.0f || lightStateRecord.globalAmbient.a != 0.0f) {
            GL11.glLightModel((int)2899, (FloatBuffer)zeroBuffer);
            lightStateRecord.globalAmbient.set(0.0f, 0.0f, 0.0f, 0.0f);
        }
    }

    private void setAmbient(int n, LightStateRecord lightStateRecord, float f, float f2, float f3, float f4, LightRecord lightRecord) {
        if (!lightStateRecord.isValid() || lightRecord.ambient.r != f || lightRecord.ambient.g != f2 || lightRecord.ambient.b != f3 || lightRecord.ambient.a != f4) {
            lightStateRecord.lightBuffer.clear();
            lightStateRecord.lightBuffer.put(f);
            lightStateRecord.lightBuffer.put(f2);
            lightStateRecord.lightBuffer.put(f3);
            lightStateRecord.lightBuffer.put(f4);
            lightStateRecord.lightBuffer.flip();
            GL11.glLight((int)(16384 + n), (int)4608, (FloatBuffer)lightStateRecord.lightBuffer);
            lightRecord.ambient.set(f, f2, f3, f4);
        }
    }

    private void setDefaultAmbient(int n, LightStateRecord lightStateRecord, LightRecord lightRecord) {
        if (!lightStateRecord.isValid() || lightRecord.ambient.r != 0.0f || lightRecord.ambient.g != 0.0f || lightRecord.ambient.b != 0.0f || lightRecord.ambient.a != 0.0f) {
            GL11.glLight((int)(16384 + n), (int)4608, (FloatBuffer)zeroBuffer);
            lightRecord.ambient.set(0.0f, 0.0f, 0.0f, 0.0f);
        }
    }

    private void setDiffuse(int n, LightStateRecord lightStateRecord, float f, float f2, float f3, float f4, LightRecord lightRecord) {
        if (!lightStateRecord.isValid() || lightRecord.diffuse.r != f || lightRecord.diffuse.g != f2 || lightRecord.diffuse.b != f3 || lightRecord.diffuse.a != f4) {
            lightStateRecord.lightBuffer.clear();
            lightStateRecord.lightBuffer.put(f);
            lightStateRecord.lightBuffer.put(f2);
            lightStateRecord.lightBuffer.put(f3);
            lightStateRecord.lightBuffer.put(f4);
            lightStateRecord.lightBuffer.flip();
            GL11.glLight((int)(16384 + n), (int)4609, (FloatBuffer)lightStateRecord.lightBuffer);
            lightRecord.diffuse.set(f, f2, f3, f4);
        }
    }

    private void setDefaultDiffuse(int n, LightStateRecord lightStateRecord, LightRecord lightRecord) {
        if (!lightStateRecord.isValid() || lightRecord.diffuse.r != 0.0f || lightRecord.diffuse.g != 0.0f || lightRecord.diffuse.b != 0.0f || lightRecord.diffuse.a != 0.0f) {
            GL11.glLight((int)(16384 + n), (int)4609, (FloatBuffer)zeroBuffer);
            lightRecord.diffuse.set(0.0f, 0.0f, 0.0f, 0.0f);
        }
    }

    private void setSpecular(int n, LightStateRecord lightStateRecord, float f, float f2, float f3, float f4, LightRecord lightRecord) {
        if (!lightStateRecord.isValid() || lightRecord.specular.r != f || lightRecord.specular.g != f2 || lightRecord.specular.b != f3 || lightRecord.specular.a != f4) {
            lightStateRecord.lightBuffer.clear();
            lightStateRecord.lightBuffer.put(f);
            lightStateRecord.lightBuffer.put(f2);
            lightStateRecord.lightBuffer.put(f3);
            lightStateRecord.lightBuffer.put(f4);
            lightStateRecord.lightBuffer.flip();
            GL11.glLight((int)(16384 + n), (int)4610, (FloatBuffer)lightStateRecord.lightBuffer);
            lightRecord.specular.set(f, f2, f3, f4);
        }
    }

    private void setDefaultSpecular(int n, LightStateRecord lightStateRecord, LightRecord lightRecord) {
        if (!lightStateRecord.isValid() || lightRecord.specular.r != 0.0f || lightRecord.specular.g != 0.0f || lightRecord.specular.b != 0.0f || lightRecord.specular.a != 0.0f) {
            GL11.glLight((int)(16384 + n), (int)4610, (FloatBuffer)zeroBuffer);
            lightRecord.specular.set(0.0f, 0.0f, 0.0f, 0.0f);
        }
    }

    private void setPosition(int n, LightStateRecord lightStateRecord, float f, float f2, float f3, float f4, LightRecord lightRecord) {
        lightStateRecord.lightBuffer.clear();
        lightStateRecord.lightBuffer.put(f);
        lightStateRecord.lightBuffer.put(f2);
        lightStateRecord.lightBuffer.put(f3);
        lightStateRecord.lightBuffer.put(f4);
        lightStateRecord.lightBuffer.flip();
        GL11.glLight((int)(16384 + n), (int)4611, (FloatBuffer)lightStateRecord.lightBuffer);
    }

    private void setSpotDirection(int n, LightStateRecord lightStateRecord, float f, float f2, float f3, float f4, LightRecord lightRecord) {
        lightStateRecord.lightBuffer.clear();
        lightStateRecord.lightBuffer.put(f);
        lightStateRecord.lightBuffer.put(f2);
        lightStateRecord.lightBuffer.put(f3);
        lightStateRecord.lightBuffer.put(f4);
        lightStateRecord.lightBuffer.flip();
        GL11.glLight((int)(16384 + n), (int)4612, (FloatBuffer)lightStateRecord.lightBuffer);
    }

    private void setConstant(int n, float f, LightRecord lightRecord, boolean bl) {
        if (bl || f != lightRecord.getConstant()) {
            GL11.glLightf((int)(16384 + n), (int)4615, (float)f);
            lightRecord.setConstant(f);
        }
    }

    private void setLinear(int n, float f, LightRecord lightRecord, boolean bl) {
        if (bl || f != lightRecord.getLinear()) {
            GL11.glLightf((int)(16384 + n), (int)4616, (float)f);
            lightRecord.setLinear(f);
        }
    }

    private void setQuadratic(int n, float f, LightRecord lightRecord, boolean bl) {
        if (bl || f != lightRecord.getQuadratic()) {
            GL11.glLightf((int)(16384 + n), (int)4617, (float)f);
            lightRecord.setQuadratic(f);
        }
    }

    private void setAttenuate(boolean bl, int n, Light light, LightStateRecord lightStateRecord, LightRecord lightRecord) {
        if (bl) {
            this.setConstant(n, light.getConstant(), lightRecord, !lightStateRecord.isValid());
            this.setLinear(n, light.getLinear(), lightRecord, !lightStateRecord.isValid());
            this.setQuadratic(n, light.getQuadratic(), lightRecord, !lightStateRecord.isValid());
        } else {
            this.setConstant(n, 1.0f, lightRecord, !lightStateRecord.isValid());
            this.setLinear(n, 0.0f, lightRecord, !lightStateRecord.isValid());
            this.setQuadratic(n, 0.0f, lightRecord, !lightStateRecord.isValid());
        }
        lightRecord.setAttenuate(bl);
    }

    private void setSpotExponent(int n, LightStateRecord lightStateRecord, float f, LightRecord lightRecord) {
        if (!lightStateRecord.isValid() || lightRecord.getSpotExponent() != f) {
            GL11.glLightf((int)(16384 + n), (int)4613, (float)f);
            lightRecord.setSpotExponent(f);
        }
    }

    private void setSpotCutoff(int n, LightStateRecord lightStateRecord, float f, LightRecord lightRecord) {
        if (!lightStateRecord.isValid() || lightRecord.getSpotCutoff() != f) {
            GL11.glLightf((int)(16384 + n), (int)4614, (float)f);
            lightRecord.setSpotCutoff(f);
        }
    }

    public StateRecord createStateRecord() {
        return new LightStateRecord();
    }

    public RenderState extract(Stack stack, SceneElement sceneElement) {
        int n = sceneElement.getLightCombineMode();
        if (n == 5 || n != 0 && stack.size() == 1) {
            return (LWJGLLightState)stack.peek();
        }
        LWJGLLightState lWJGLLightState = new LWJGLLightState();
        Object[] objectArray = stack.toArray();
        boolean bl = false;
        block0 : switch (n) {
            case 2: 
            case 3: {
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    LWJGLLightState lWJGLLightState2 = (LWJGLLightState)objectArray[i];
                    if (!lWJGLLightState2.isEnabled()) {
                        if (n != 3) continue;
                        break block0;
                    }
                    bl = true;
                    if (lWJGLLightState2.twoSidedOn) {
                        lWJGLLightState.setTwoSidedLighting(true);
                    }
                    if (lWJGLLightState2.localViewerOn) {
                        lWJGLLightState.setLocalViewer(true);
                    }
                    if (lWJGLLightState2.separateSpecularOn) {
                        lWJGLLightState.setSeparateSpecular(true);
                    }
                    int n2 = lWJGLLightState2.getQuantity();
                    for (int j = 0; j < n2; ++j) {
                        Light light = lWJGLLightState2.get(j);
                        if (light == null) continue;
                        lWJGLLightState.attach(light);
                    }
                }
                break;
            }
            case 1: {
                int n3 = objectArray.length;
                for (int i = 0; i < n3; ++i) {
                    LWJGLLightState lWJGLLightState3 = (LWJGLLightState)objectArray[i];
                    if (!lWJGLLightState3.isEnabled()) continue;
                    bl = true;
                    if (lWJGLLightState3.twoSidedOn) {
                        lWJGLLightState.setTwoSidedLighting(true);
                    }
                    if (lWJGLLightState3.localViewerOn) {
                        lWJGLLightState.setLocalViewer(true);
                    }
                    if (lWJGLLightState3.separateSpecularOn) {
                        lWJGLLightState.setSeparateSpecular(true);
                    }
                    int n4 = lWJGLLightState3.getQuantity();
                    for (int j = 0; j < n4; ++j) {
                        Light light = lWJGLLightState3.get(j);
                        if (light == null) continue;
                        lWJGLLightState.attach(light);
                    }
                }
                break;
            }
        }
        lWJGLLightState.setEnabled(bl);
        return lWJGLLightState;
    }
}

