/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.client.sample.jme;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jp.sourceforge.mmosf.client.sample.jme.QuestInfo;
import jp.sourceforge.mmosf.server.packet.Packet;
import jp.sourceforge.mmosf.server.packet.PacketFormatException;

public class JQuestListPanel2
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected List<QuestInfo> listQuestInfo;
    protected JLabel label;

    public JQuestListPanel2() {
        this.init();
    }

    protected void init() {
        this.listQuestInfo = new LinkedList<QuestInfo>();
        this.label = new JLabel();
        this.add(this.label);
    }

    public void addNewQuest(Packet packet) throws PacketFormatException {
        QuestInfo info = new QuestInfo();
        this.listQuestInfo.add(info);
        info.setQuestPacket(packet);
        this.redrawList();
    }

    public void updateQuest(Packet packet) throws PacketFormatException {
        int questId = packet.getInt("questId");
        for (QuestInfo info : this.listQuestInfo) {
            if (info.getQuestId() != questId) continue;
            info.setQuestPacket(packet);
        }
        this.redrawList();
    }

    public void removeQuest(Packet packet) throws PacketFormatException {
        int questId = packet.getInt("questId");
        Iterator<QuestInfo> it = this.listQuestInfo.iterator();
        while (it.hasNext()) {
            QuestInfo info = it.next();
            if (info.getQuestId() != questId) continue;
            it.remove();
        }
        this.redrawList();
    }

    protected void redrawList() {
        Iterator<QuestInfo> it = this.listQuestInfo.iterator();
        StringBuffer sb = new StringBuffer();
        sb.append("<html><div style=\"width:100%\">");
        while (it.hasNext()) {
            QuestInfo info = it.next();
            sb.append(info.toString());
        }
        sb.append("</div></html>");
        this.label.setText(sb.toString());
    }
}

