/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server.sync.test;

import java.util.List;
import jp.sourceforge.mmosf.server.Perception;
import jp.sourceforge.mmosf.server.UserConnection;
import jp.sourceforge.mmosf.server.object.Mob;
import jp.sourceforge.mmosf.server.object.MoveObject;
import jp.sourceforge.mmosf.server.object.PlayerCharactor;
import jp.sourceforge.mmosf.server.object.Position;
import jp.sourceforge.mmosf.server.object.Vector;
import jp.sourceforge.mmosf.server.sync.AreaIndex;
import jp.sourceforge.mmosf.server.sync.SyncShard;
import org.junit.Assert;
import org.junit.Test;

public class TestSync
implements Perception {
    public boolean isCollision(MoveObject mo) {
        return false;
    }

    public boolean isEnableMove(MoveObject mo) {
        return true;
    }

    @Test
    public void testAreaIndex1() {
        Position pos = new Position();
        pos.set(0, 0, 0);
        AreaIndex index = AreaIndex.getAreaIndex(pos);
        this.assertEquals(index, 0, 0, 0);
    }

    @Test
    public void testAreaIndex2() {
        Position pos = new Position();
        pos.set(0, 0, 0);
        List<AreaIndex> list = AreaIndex.getAreaIndexAround(pos);
        this.assertEquals(list.get(0), 0, -1, 0);
        this.assertEquals(list.get(1), 1, -1, 0);
        this.assertEquals(list.get(2), -1, 0, 0);
        this.assertEquals(list.get(3), 1, 0, 0);
        this.assertEquals(list.get(4), 0, 1, 0);
        this.assertEquals(list.get(5), 1, 1, 0);
    }

    @Test
    public void testAreaIndex3() {
        Position pos = new Position();
        pos.set(0, 10, 0);
        List<AreaIndex> list = AreaIndex.getAreaIndexAround(pos);
        this.assertEquals(list.get(0), -1, 0, 0);
        this.assertEquals(list.get(1), 0, 0, 0);
        this.assertEquals(list.get(2), -1, 1, 0);
        this.assertEquals(list.get(3), 1, 1, 0);
        this.assertEquals(list.get(4), -1, 2, 0);
        this.assertEquals(list.get(5), 0, 2, 0);
    }

    private void assertEquals(AreaIndex index, int x, int y, int z) {
        Assert.assertEquals((Object)index.getX(), (Object)x);
        Assert.assertEquals((Object)index.getY(), (Object)y);
        Assert.assertEquals((Object)index.getZ(), (Object)z);
    }

    @Test
    public void testSync() {
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testMoveUp() {
        try {
            SyncShard shard = new SyncShard();
            int i = 0;
            while (i < 10) {
                PlayerCharactor pc = new PlayerCharactor(i, 0, Character.valueOf('A'), 0, new UserConnection(null));
                shard.getSyncArea(pc.getPos()).in(pc);
                List<Mob> list = shard.getSyncArea(pc.getPos()).gatherMob();
                Assert.assertFalse((list.indexOf(pc) == -1 ? 1 : 0) != 0);
                Position oldPos = new Position(pc.getPos());
                Vector v = new Vector();
                v.x = 0;
                v.y = -1;
                pc.setVector(v);
                pc.moving.move(pc, this);
                shard.getSyncZone(pc.getPos()).move(pc, oldPos, pc.getPos());
                List<Mob> list2 = shard.getSyncArea(oldPos).gatherMob();
                Assert.assertTrue((list2.indexOf(pc) == -1 ? 1 : 0) != 0);
                List<Mob> list3 = shard.getSyncArea(pc.getPos()).gatherMob();
                Assert.assertFalse((list3.indexOf(pc) == -1 ? 1 : 0) != 0);
                ++i;
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testMoveDown() {
        try {
            SyncShard shard = new SyncShard();
            int i = 0;
            while (i < 10) {
                PlayerCharactor pc = new PlayerCharactor(i, 9, Character.valueOf('A'), 0, new UserConnection(null));
                shard.getSyncArea(pc.getPos()).in(pc);
                List<Mob> list = shard.getSyncArea(pc.getPos()).gatherMob();
                Assert.assertFalse((list.indexOf(pc) == -1 ? 1 : 0) != 0);
                Position oldPos = new Position(pc.getPos());
                Vector v = new Vector();
                v.x = 0;
                v.y = 1;
                pc.setVector(v);
                pc.moving.move(pc, this);
                shard.getSyncZone(pc.getPos()).move(pc, oldPos, pc.getPos());
                List<Mob> list2 = shard.getSyncArea(oldPos).gatherMob();
                Assert.assertTrue((list2.indexOf(pc) == -1 ? 1 : 0) != 0);
                List<Mob> list3 = shard.getSyncArea(pc.getPos()).gatherMob();
                Assert.assertFalse((list3.indexOf(pc) == -1 ? 1 : 0) != 0);
                ++i;
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testMoveLeft() {
        try {
            SyncShard shard = new SyncShard();
            int i = 0;
            while (i < 10) {
                PlayerCharactor pc = new PlayerCharactor(0, i, Character.valueOf('A'), 0, new UserConnection(null));
                shard.getSyncArea(pc.getPos()).in(pc);
                List<Mob> list = shard.getSyncArea(pc.getPos()).gatherMob();
                Assert.assertFalse((list.indexOf(pc) == -1 ? 1 : 0) != 0);
                Position oldPos = new Position(pc.getPos());
                Vector v = new Vector();
                v.x = -1;
                v.y = 0;
                pc.setVector(v);
                pc.moving.move(pc, this);
                shard.getSyncZone(pc.getPos()).move(pc, oldPos, pc.getPos());
                List<Mob> list2 = shard.getSyncArea(oldPos).gatherMob();
                Assert.assertTrue((list2.indexOf(pc) == -1 ? 1 : 0) != 0);
                List<Mob> list3 = shard.getSyncArea(pc.getPos()).gatherMob();
                Assert.assertFalse((list3.indexOf(pc) == -1 ? 1 : 0) != 0);
                ++i;
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testMoveRight() {
        try {
            SyncShard shard = new SyncShard();
            int i = 0;
            while (i < 10) {
                PlayerCharactor pc = new PlayerCharactor(9, i, Character.valueOf('A'), 0, new UserConnection(null));
                shard.getSyncArea(pc.getPos()).in(pc);
                List<Mob> list = shard.getSyncArea(pc.getPos()).gatherMob();
                Assert.assertFalse((list.indexOf(pc) == -1 ? 1 : 0) != 0);
                Position oldPos = new Position(pc.getPos());
                Vector v = new Vector();
                v.x = 1;
                v.y = 0;
                pc.setVector(v);
                pc.moving.move(pc, this);
                shard.getSyncZone(pc.getPos()).move(pc, oldPos, pc.getPos());
                List<Mob> list2 = shard.getSyncArea(oldPos).gatherMob();
                Assert.assertTrue((list2.indexOf(pc) == -1 ? 1 : 0) != 0);
                List<Mob> list3 = shard.getSyncArea(pc.getPos()).gatherMob();
                Assert.assertFalse((list3.indexOf(pc) == -1 ? 1 : 0) != 0);
                ++i;
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }
}

