/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server.test;

import java.util.Iterator;
import java.util.List;
import jp.sourceforge.mmosf.server.Perception;
import jp.sourceforge.mmosf.server.UserConnection;
import jp.sourceforge.mmosf.server.level.MobFactory;
import jp.sourceforge.mmosf.server.object.ChatMessage;
import jp.sourceforge.mmosf.server.object.Mob;
import jp.sourceforge.mmosf.server.object.MovingRnd;
import jp.sourceforge.mmosf.server.object.PlayerCharactor;
import jp.sourceforge.mmosf.server.object.Position;
import jp.sourceforge.mmosf.server.object.Vector;
import jp.sourceforge.mmosf.server.packet.Packet;
import jp.sourceforge.mmosf.server.packet.PacketFactory;
import jp.sourceforge.mmosf.server.test.TestConnection;
import jp.sourceforge.mmosf.server.test.TestMatchingServer;
import org.junit.Assert;
import org.junit.Test;

public class MatchingServerTest {
    private static TestMatchingServer testMatchingServer;

    @Test
    public void testIsCollisionUp() {
        TestMatchingServer ms = MatchingServerTest.getMatchingServer();
        int i = 0;
        while (i < 10) {
            PlayerCharactor npc = new PlayerCharactor(i, -1, Character.valueOf('A'), 0, new UserConnection(null));
            ms.register(npc);
            PlayerCharactor pc = new PlayerCharactor(i, 0, Character.valueOf('B'), 1, new UserConnection(null));
            ms.register(pc);
            Assert.assertNotSame((Object)ms.getSyncShard().getSyncArea(npc.getPos()), (Object)ms.getSyncShard().getSyncArea(pc.getPos()));
            Vector v = new Vector();
            v.x = 0;
            v.y = -1;
            pc.setVector(v);
            Assert.assertTrue((boolean)ms.isCollision(pc.moving.createMoveObject(pc)));
            ms.unregister(pc);
            ms.unregister(npc);
            ++i;
        }
    }

    @Test
    public void testIsCollisionDown() {
        TestMatchingServer ms = MatchingServerTest.getMatchingServer();
        int i = 0;
        while (i < 10) {
            PlayerCharactor npc = new PlayerCharactor(i, 10, Character.valueOf('A'), 0, new UserConnection(null));
            ms.register(npc);
            PlayerCharactor pc = new PlayerCharactor(i, 9, Character.valueOf('B'), 1, new UserConnection(null));
            ms.register(pc);
            Assert.assertNotSame((Object)ms.getSyncShard().getSyncArea(npc.getPos()), (Object)ms.getSyncShard().getSyncArea(pc.getPos()));
            pc.setVector(Vector.SOUTH);
            Assert.assertTrue((boolean)ms.isCollision(pc.moving.createMoveObject(pc)));
            ms.unregister(pc);
            ms.unregister(npc);
            ++i;
        }
    }

    @Test
    public void testIsCollisionLeft() {
        TestMatchingServer ms = MatchingServerTest.getMatchingServer();
        int i = 0;
        while (i < 10) {
            PlayerCharactor npc = new PlayerCharactor(-1, i, Character.valueOf('A'), 0, new UserConnection(null));
            ms.register(npc);
            PlayerCharactor pc = new PlayerCharactor(0, i, Character.valueOf('B'), 1, new UserConnection(null));
            ms.register(pc);
            Assert.assertNotSame((Object)ms.getSyncShard().getSyncArea(npc.getPos()), (Object)ms.getSyncShard().getSyncArea(pc.getPos()));
            pc.setVector(Vector.WEST);
            Assert.assertTrue((boolean)ms.isCollision(pc.moving.createMoveObject(pc)));
            ms.unregister(pc);
            ms.unregister(npc);
            ++i;
        }
    }

    @Test
    public void testIsCollisionRight() {
        TestMatchingServer ms = MatchingServerTest.getMatchingServer();
        int i = 0;
        while (i < 10) {
            PlayerCharactor npc = new PlayerCharactor(10, i, Character.valueOf('A'), 0, new UserConnection(null));
            ms.register(npc);
            PlayerCharactor pc = new PlayerCharactor(9, i, Character.valueOf('B'), 1, new UserConnection(null));
            ms.register(pc);
            Assert.assertNotSame((Object)ms.getSyncShard().getSyncArea(npc.getPos()), (Object)ms.getSyncShard().getSyncArea(pc.getPos()));
            pc.setVector(Vector.EAST);
            Assert.assertTrue((boolean)ms.isCollision(pc.moving.createMoveObject(pc)));
            ms.unregister(pc);
            ms.unregister(npc);
            ++i;
        }
    }

    @Test
    public void testSayUp() {
        try {
            TestMatchingServer ms = MatchingServerTest.getMatchingServer();
            int i = 0;
            while (i < 10) {
                PlayerCharactor pc1 = new PlayerCharactor(i, -1, Character.valueOf('A'), 0, new TestConnection(null, null));
                ms.register(pc1);
                PlayerCharactor pc2 = new PlayerCharactor(i, 0, Character.valueOf('B'), 1, new TestConnection(null, null));
                ms.register(pc2);
                Assert.assertNotSame((Object)ms.getSyncShard().getSyncArea(pc1.getPos()), (Object)ms.getSyncShard().getSyncArea(pc2.getPos()));
                Packet packet = PacketFactory.createMessagePacket(ChatMessage.createSay("A", "Hello."));
                ms.put(packet, pc1);
                List<Packet> list = ((TestConnection)pc2.conn).getSendPacket();
                Iterator<Packet> it = list.iterator();
                Packet ret = null;
                while (it.hasNext()) {
                    ret = it.next();
                    Assert.assertNotNull((Object)ret);
                    if (ret.getType() == 6) continue;
                    Assert.assertEquals((long)ret.getType(), (long)2L);
                    break;
                }
                Assert.assertTrue((boolean)ret.getString("MESSAGE").equals("Hello."));
                ++i;
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testSayDown() {
        try {
            TestMatchingServer ms = MatchingServerTest.getMatchingServer();
            int i = 0;
            while (i < 10) {
                PlayerCharactor pc1 = new PlayerCharactor(i, 10, Character.valueOf('A'), 0, new TestConnection(null, null));
                ms.register(pc1);
                PlayerCharactor pc2 = new PlayerCharactor(i, 9, Character.valueOf('B'), 1, new TestConnection(null, null));
                ms.register(pc2);
                Assert.assertNotSame((Object)ms.getSyncShard().getSyncArea(pc1.getPos()), (Object)ms.getSyncShard().getSyncArea(pc2.getPos()));
                Packet packet = PacketFactory.createMessagePacket(ChatMessage.createSay("A", "Hello."));
                ms.put(packet, pc1);
                List<Packet> list = ((TestConnection)pc2.conn).getSendPacket();
                Iterator<Packet> it = list.iterator();
                Packet ret = null;
                while (it.hasNext()) {
                    ret = it.next();
                    Assert.assertNotNull((Object)ret);
                    if (ret.getType() == 6) continue;
                    Assert.assertEquals((long)ret.getType(), (long)2L);
                    break;
                }
                Assert.assertTrue((boolean)ret.getString("MESSAGE").equals("Hello."));
                ms.unregister(pc2);
                ms.unregister(pc1);
                ++i;
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testSayLeft() {
        try {
            TestMatchingServer ms = MatchingServerTest.getMatchingServer();
            int i = 0;
            while (i < 10) {
                PlayerCharactor pc1 = new PlayerCharactor(-1, i, Character.valueOf('A'), 0, new TestConnection(null, null));
                ms.register(pc1);
                PlayerCharactor pc2 = new PlayerCharactor(0, i, Character.valueOf('B'), 1, new TestConnection(null, null));
                ms.register(pc2);
                Assert.assertNotSame((Object)ms.getSyncShard().getSyncArea(pc1.getPos()), (Object)ms.getSyncShard().getSyncArea(pc2.getPos()));
                Packet packet = PacketFactory.createMessagePacket(ChatMessage.createSay("A", "Hello."));
                ms.put(packet, pc1);
                List<Packet> list = ((TestConnection)pc2.conn).getSendPacket();
                Iterator<Packet> it = list.iterator();
                Packet ret = null;
                while (it.hasNext()) {
                    ret = it.next();
                    Assert.assertNotNull((Object)ret);
                    if (ret.getType() == 6) continue;
                    Assert.assertEquals((long)ret.getType(), (long)2L);
                    break;
                }
                Assert.assertTrue((boolean)ret.getString("MESSAGE").equals("Hello."));
                ms.unregister(pc2);
                ms.unregister(pc1);
                ++i;
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testSayRight() {
        try {
            TestMatchingServer ms = MatchingServerTest.getMatchingServer();
            int i = 0;
            while (i < 10) {
                PlayerCharactor pc1 = new PlayerCharactor(10, i, Character.valueOf('A'), 0, new TestConnection(null, null));
                ms.register(pc1);
                PlayerCharactor pc2 = new PlayerCharactor(9, i, Character.valueOf('B'), 1, new TestConnection(null, null));
                ms.register(pc2);
                Assert.assertNotSame((Object)ms.getSyncShard().getSyncArea(pc1.getPos()), (Object)ms.getSyncShard().getSyncArea(pc2.getPos()));
                Packet packet = PacketFactory.createMessagePacket(ChatMessage.createSay("A", "Hello."));
                ms.put(packet, pc1);
                List<Packet> list = ((TestConnection)pc2.conn).getSendPacket();
                Iterator<Packet> it = list.iterator();
                Packet ret = null;
                while (it.hasNext()) {
                    ret = it.next();
                    Assert.assertNotNull((Object)ret);
                    if (ret.getType() == 6) continue;
                    Assert.assertEquals((long)ret.getType(), (long)2L);
                    break;
                }
                Assert.assertTrue((boolean)ret.getString("MESSAGE").equals("Hello."));
                ms.unregister(pc2);
                ms.unregister(pc1);
                ++i;
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testMoveRnd() {
        try {
            TestMatchingServer ms = MatchingServerTest.getMatchingServer();
            Mob mob = new Mob(5, 5, Character.valueOf('A'), 1, 0);
            class TestMovingRnd
            extends MovingRnd {
                public void moveRnd(Mob mob, Perception prc) {
                    super.moveRnd(mob, prc);
                }
            }
            TestMovingRnd mr = new TestMovingRnd();
            int i = 0;
            while (i < 100) {
                Position next = new Position(mr.nextPos);
                mr.moveRnd(mob, ms);
                Assert.assertFalse((boolean)mr.nextPos.equals(next));
                mob.setPos(mr.nextPos);
                ++i;
            }
        }
        catch (Throwable e) {
            Assert.fail((String)e.toString());
        }
    }

    public static TestMatchingServer getMatchingServer() {
        if (testMatchingServer == null) {
            testMatchingServer = new TestMatchingServer();
        }
        return testMatchingServer;
    }

    @Test
    public void testQuest() {
        try {
            TestMatchingServer server = MatchingServerTest.getMatchingServer();
            Position pos = new Position();
            pos.set(20, 20, 0);
            Mob npca = MobFactory.createQuestMobA(pos, 10000);
            server.getSyncShard().getSyncArea(pos).in(npca);
            PlayerCharactor pc1 = new PlayerCharactor(21, 20, Character.valueOf('A'), 10001, new TestConnection(null, null));
            server.register(pc1);
            Packet pac = PacketFactory.createMenuRequestPaket(npca);
            server.put(pac, pc1);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }
}

