/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.animation;

import com.jme.math.Quaternion;
import com.jme.math.TransformMatrix;
import com.jme.math.Vector3f;
import com.jme.scene.Controller;
import com.jme.system.JmeException;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import com.jme.util.geom.BufferUtils;
import com.jmex.model.JointMesh;
import com.jmex.model.animation.PointInTime;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.ArrayList;

public class JointController
extends Controller {
    private static final long serialVersionUID = 1L;
    public int numJoints;
    public ArrayList<PointInTime> movementInfo;
    public int[] parentIndex;
    public TransformMatrix[] localRefMatrix;
    public float FPS;
    public ArrayList<JointMesh> movingMeshes;
    private float curTime;
    private int curTimePoint;
    private TransformMatrix[] jointMovements;
    private TransformMatrix[] inverseChainMatrix;
    private static final Quaternion unSyncbeginAngle = new Quaternion();
    private static final Vector3f unSyncbeginPos = new Vector3f();
    private static final TransformMatrix tempUnSyncd = new TransformMatrix();
    public float skipRate;
    private float currentSkip;
    private boolean updatePerFrame = true;
    private boolean movingForward = true;

    public JointController() {
        this.curTime = 0.0f;
        this.curTimePoint = 1;
    }

    public JointController(int n) {
        this.numJoints = n;
        this.parentIndex = new int[n];
        this.localRefMatrix = new TransformMatrix[n];
        this.movingMeshes = new ArrayList();
        this.jointMovements = new TransformMatrix[n];
        this.inverseChainMatrix = new TransformMatrix[n];
        for (int i = 0; i < n; ++i) {
            this.localRefMatrix[i] = new TransformMatrix();
            this.jointMovements[i] = new TransformMatrix();
            this.inverseChainMatrix[i] = new TransformMatrix();
        }
        this.movementInfo = new ArrayList();
        this.curTime = 0.0f;
        this.curTimePoint = 1;
        this.currentSkip = 0.0f;
        this.skipRate = 0.01f;
    }

    public float getCurrentTime() {
        return this.curTime;
    }

    public void setTranslation(int n, float f, float f2, float f3, float f4) {
        this.findUpToTime(f).setTranslation(n, f2, f3, f4);
    }

    public void setTranslation(int n, float f, Vector3f vector3f) {
        this.findUpToTime(f).setTranslation(n, vector3f);
    }

    public void setRotation(int n, float f, float f2, float f3, float f4) {
        this.findUpToTime(f).setRotation(n, f2, f3, f4);
    }

    public void setRotation(int n, float f, Quaternion quaternion) {
        this.findUpToTime(f).setRotation(n, quaternion);
    }

    private PointInTime findUpToTime(float f) {
        int n = 0;
        for (PointInTime pointInTime : this.movementInfo) {
            float f2 = pointInTime.time;
            if (f2 >= f) break;
            ++n;
        }
        Object object = null;
        if (n == this.movementInfo.size()) {
            object = new PointInTime(this.numJoints);
            this.movementInfo.add((PointInTime)object);
            ((PointInTime)object).time = f;
        } else if (this.movementInfo.get((int)n).time == f) {
            object = this.movementInfo.get(n);
        } else {
            object = new PointInTime(this.numJoints);
            this.movementInfo.add(n, (PointInTime)object);
            ((PointInTime)object).time = f;
        }
        return object;
    }

    public void update(float f) {
        if (this.numJoints == 0) {
            return;
        }
        this.curTime = this.movingForward ? (this.curTime += f * this.getSpeed()) : (this.curTime -= f * this.getSpeed());
        this.currentSkip += f;
        if (!(this.currentSkip >= this.skipRate)) {
            return;
        }
        this.currentSkip = 0.0f;
        this.setCurTimePoint();
        PointInTime pointInTime = this.movementInfo.get(this.curTimePoint);
        PointInTime pointInTime2 = this.movementInfo.get(this.curTimePoint - 1);
        float f2 = (this.curTime - pointInTime2.time) / (pointInTime.time - pointInTime2.time);
        this.createJointTransforms(f2);
        this.combineWithInverse();
        this.updateData();
    }

    private void setCurTimePoint() {
        int n = this.getRepeatType();
        if (this.curTime > this.getMaxTime()) {
            if (n == 1) {
                this.curTime = this.getMinTime();
            } else if (n == 2) {
                this.curTime = this.getMaxTime();
                this.movingForward = false;
            } else if (n == 0) {
                this.setActive(false);
                this.curTime = this.getMaxTime();
            }
        }
        if (this.curTime < this.getMinTime()) {
            if (n == 1) {
                this.curTime = this.getMaxTime();
            } else if (n == 2) {
                this.curTime = this.getMinTime();
                this.movingForward = true;
            } else if (n == 0) {
                this.setActive(false);
                this.curTime = this.getMinTime();
            }
        }
        PointInTime pointInTime = this.movementInfo.get(this.curTimePoint);
        PointInTime pointInTime2 = this.movementInfo.get(this.curTimePoint - 1);
        if (this.curTime <= pointInTime.time && this.curTime >= pointInTime2.time) {
            return;
        }
        this.curTimePoint = 1;
        while (this.curTimePoint < this.movementInfo.size()) {
            pointInTime = this.movementInfo.get(this.curTimePoint);
            if (pointInTime.time >= this.curTime) {
                return;
            }
            ++this.curTimePoint;
        }
    }

    public void setTimes(int n, int n2) {
        if (n < 0 || n > n2 || this.movementInfo.get((int)(this.movementInfo.size() - 1)).time < (float)n2 / this.FPS) {
            String string = "Malformed times: start=" + n + " end=" + n2 + " start limit: 0 End limit: " + this.movementInfo.get((int)(this.movementInfo.size() - 1)).time * this.FPS;
            throw new JmeException(string);
        }
        this.setMinTime((float)n / this.FPS);
        this.setMaxTime((float)n2 / this.FPS);
        this.curTime = this.getMinTime();
        this.curTimePoint = 1;
        this.movingForward = true;
    }

    private void updateData() {
        for (int i = 0; i < this.movingMeshes.size(); ++i) {
            int n;
            JointMesh jointMesh = this.movingMeshes.get(i);
            FloatBuffer floatBuffer = jointMesh.getVertexBuffer(0);
            FloatBuffer floatBuffer2 = jointMesh.getNormalBuffer(0);
            for (n = 0; n < jointMesh.jointIndex.length; ++n) {
                int n2 = jointMesh.jointIndex[n];
                if (n2 == -1) continue;
                unSyncbeginPos.set(jointMesh.originalVertex[n]);
                BufferUtils.setInBuffer((Vector3f)this.jointMovements[n2].multPoint(unSyncbeginPos), (FloatBuffer)floatBuffer, (int)n);
                unSyncbeginPos.set(jointMesh.originalNormal[n]);
                BufferUtils.setInBuffer((Vector3f)this.jointMovements[n2].multNormal(unSyncbeginPos), (FloatBuffer)floatBuffer2, (int)n);
            }
            if (n == 0 || !this.updatePerFrame) continue;
            jointMesh.updateModelBound();
        }
    }

    private void combineWithInverse() {
        for (int i = 0; i < this.numJoints; ++i) {
            this.jointMovements[i].multLocal(this.inverseChainMatrix[i], unSyncbeginPos);
        }
    }

    public void processController() {
        if (this.movementInfo.size() == 1) {
            this.movementInfo.add(0, new PointInTime(0));
        }
        this.setMinTime(this.movementInfo.get((int)0).time);
        this.setMaxTime(this.movementInfo.get((int)(this.movementInfo.size() - 1)).time);
        this.curTime = this.getMinTime();
        this.invertWithParents();
        this.fillHoles();
    }

    public void setModelUpdate(boolean bl) {
        this.updatePerFrame = bl;
    }

    public boolean getModelUpdate() {
        return this.updatePerFrame;
    }

    private void invertWithParents() {
        for (int i = 0; i < this.numJoints; ++i) {
            this.inverseChainMatrix[i] = new TransformMatrix(this.localRefMatrix[i]);
            this.inverseChainMatrix[i].inverse();
            if (this.parentIndex[i] == -1) continue;
            this.inverseChainMatrix[i].multLocal(this.inverseChainMatrix[this.parentIndex[i]], unSyncbeginPos);
        }
    }

    private void createJointTransforms(float f) {
        PointInTime pointInTime = this.movementInfo.get(this.curTimePoint);
        PointInTime pointInTime2 = this.movementInfo.get(this.curTimePoint - 1);
        for (int i = 0; i < this.numJoints; ++i) {
            int n = this.parentIndex[i];
            unSyncbeginAngle.set(pointInTime2.jointRotation[i]);
            unSyncbeginPos.set(pointInTime2.jointTranslation[i]);
            unSyncbeginAngle.slerp(pointInTime.jointRotation[i], f);
            unSyncbeginPos.interpolate(pointInTime.jointTranslation[i], f);
            tempUnSyncd.set(unSyncbeginAngle, unSyncbeginPos);
            this.jointMovements[i].set(this.localRefMatrix[i]);
            this.jointMovements[i].multLocal(tempUnSyncd, unSyncbeginPos);
            if (n == -1) continue;
            tempUnSyncd.set(this.jointMovements[i]);
            this.jointMovements[i].set(this.jointMovements[n]);
            this.jointMovements[i].multLocal(tempUnSyncd, unSyncbeginPos);
        }
    }

    private void fillHoles() {
        this.fillRots();
        this.fillTrans();
    }

    private void fillRots() {
        for (int i = 0; i < this.numJoints; ++i) {
            int n;
            int n2;
            for (n2 = 0; n2 < this.movementInfo.size() && this.movementInfo.get((int)n2).jointRotation[i] == null; ++n2) {
            }
            if (n2 == this.movementInfo.size()) {
                for (n = 0; n < this.movementInfo.size(); ++n) {
                    this.movementInfo.get((int)n).jointRotation[i] = new Quaternion();
                }
                continue;
            }
            if (n2 != 0) {
                unSyncbeginAngle.set(this.movementInfo.get((int)n2).jointRotation[i]);
                for (n = 0; n < n2; ++n) {
                    this.movementInfo.get((int)n).jointRotation[i] = new Quaternion(unSyncbeginAngle);
                }
            }
            n = n2;
            boolean bl = true;
            for (int j = n2 + 2; j < this.movementInfo.size(); ++j) {
                if (this.movementInfo.get((int)j).jointRotation[i] == null) continue;
                this.fillQuats(i, n, j);
                n = j;
                bl = false;
            }
            if (bl || n == this.movementInfo.size() - 1) continue;
            this.movementInfo.get((int)(this.movementInfo.size() - 1)).jointRotation[i] = new Quaternion(this.movementInfo.get((int)n).jointRotation[i]);
            this.fillQuats(i, n, this.movementInfo.size() - 1);
        }
    }

    private void fillTrans() {
        for (int i = 0; i < this.numJoints; ++i) {
            int n;
            int n2;
            for (n2 = 0; n2 < this.movementInfo.size() && this.movementInfo.get((int)n2).jointTranslation[i] == null; ++n2) {
            }
            if (n2 == this.movementInfo.size()) {
                for (n = 0; n < this.movementInfo.size(); ++n) {
                    this.movementInfo.get((int)n).jointTranslation[i] = new Vector3f(0.0f, 0.0f, 0.0f);
                }
                continue;
            }
            if (n2 != 0) {
                unSyncbeginPos.set(this.movementInfo.get((int)n2).jointTranslation[i]);
                for (n = 0; n < n2; ++n) {
                    this.movementInfo.get((int)n).jointTranslation[i] = new Vector3f(unSyncbeginPos);
                }
            }
            n = n2;
            boolean bl = true;
            for (int j = n2 + 2; j < this.movementInfo.size(); ++j) {
                if (this.movementInfo.get((int)j).jointTranslation[i] == null) continue;
                this.fillPos(i, n, j);
                n = j;
                bl = false;
            }
            if (bl || n == this.movementInfo.size() - 1) continue;
            this.movementInfo.get((int)(this.movementInfo.size() - 1)).jointTranslation[i] = new Vector3f(this.movementInfo.get((int)n).jointTranslation[i]);
            this.fillPos(i, n, this.movementInfo.size() - 1);
        }
    }

    private void fillQuats(int n, int n2, int n3) {
        unSyncbeginAngle.set(this.movementInfo.get((int)n2).jointRotation[n]);
        for (int i = n2 + 1; i < n3; ++i) {
            this.movementInfo.get((int)i).jointRotation[n] = new Quaternion(unSyncbeginAngle);
            this.movementInfo.get((int)i).jointRotation[n].slerp(this.movementInfo.get((int)n3).jointRotation[n], ((float)i - (float)n2) / (float)(n3 - n2));
        }
    }

    private void fillPos(int n, int n2, int n3) {
        unSyncbeginPos.set(this.movementInfo.get((int)n2).jointTranslation[n]);
        for (int i = n2 + 1; i < n3; ++i) {
            this.movementInfo.get((int)i).jointTranslation[n] = new Vector3f(unSyncbeginPos);
            this.movementInfo.get((int)i).jointTranslation[n].interpolate(this.movementInfo.get((int)n3).jointTranslation[n], ((float)i - (float)n2) / (float)(n3 - n2));
        }
    }

    public void addJointMesh(JointMesh jointMesh) {
        this.movingMeshes.add(jointMesh);
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule((Savable)this);
        outputCapsule.write(this.numJoints, "numJoints", 0);
        outputCapsule.writeSavableArrayList(this.movementInfo, "movementInfo", new ArrayList());
        outputCapsule.write(this.parentIndex, "parentIndex", new int[this.numJoints]);
        outputCapsule.write((Savable[])this.localRefMatrix, "localRefMatrix", (Savable[])new TransformMatrix[this.numJoints]);
        outputCapsule.write(this.FPS, "FPS", 0.0f);
        outputCapsule.writeSavableArrayList(this.movingMeshes, "movingMeshes", new ArrayList());
        outputCapsule.write((Savable[])this.jointMovements, "jointMovements", (Savable[])new TransformMatrix[this.numJoints]);
        outputCapsule.write(this.skipRate, "skipRate", 0.0f);
        outputCapsule.write(this.updatePerFrame, "updatePerFrame", false);
        outputCapsule.write(this.movingForward, "movingForward", false);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        int n;
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule((Savable)this);
        this.numJoints = inputCapsule.readInt("numJoints", 0);
        this.movementInfo = inputCapsule.readSavableArrayList("movementInfo", new ArrayList());
        this.parentIndex = inputCapsule.readIntArray("parentIndex", new int[this.numJoints]);
        Savable[] savableArray = inputCapsule.readSavableArray("localRefMatrix", (Savable[])new TransformMatrix[this.numJoints]);
        if (savableArray == null) {
            this.localRefMatrix = null;
        } else {
            this.localRefMatrix = new TransformMatrix[savableArray.length];
            for (n = 0; n < savableArray.length; ++n) {
                this.localRefMatrix[n] = (TransformMatrix)savableArray[n];
            }
        }
        savableArray = inputCapsule.readSavableArray("jointMovements", (Savable[])new TransformMatrix[this.numJoints]);
        if (savableArray == null) {
            this.jointMovements = null;
        } else {
            this.jointMovements = new TransformMatrix[savableArray.length];
            for (n = 0; n < savableArray.length; ++n) {
                this.jointMovements[n] = (TransformMatrix)savableArray[n];
            }
        }
        this.FPS = inputCapsule.readFloat("FPS", 0.0f);
        this.movingMeshes = inputCapsule.readSavableArrayList("movingMeshes", new ArrayList());
        this.skipRate = inputCapsule.readFloat("skipRate", 0.0f);
        this.updatePerFrame = inputCapsule.readBoolean("updatePerFrame", false);
        this.movingForward = inputCapsule.readBoolean("movingForward", false);
        this.inverseChainMatrix = new TransformMatrix[this.numJoints];
        for (n = 0; n < this.numJoints; ++n) {
            this.inverseChainMatrix[n] = new TransformMatrix();
        }
        this.processController();
    }
}

