/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.converters;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.logging.Logger;

public abstract class FormatConverter {
    private static final Logger logger = Logger.getLogger(FormatConverter.class.getName());
    HashMap<String, Object> properties = new HashMap();

    public abstract void convert(InputStream var1, OutputStream var2) throws IOException;

    public void attemptFileConvert(String[] stringArray) {
        if (stringArray.length != 2) {
            logger.info("Correct way to use is: <FormatFile> <jmeoutputfile>");
            logger.info("For example: runner.txt runner.jme");
            return;
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        if (!file.canRead()) {
            logger.warning("Cannot read input file " + file);
            return;
        }
        try {
            logger.info("Converting file " + file.getCanonicalPath() + " to " + file2.getCanonicalPath());
            this.convert(new FileInputStream(file), new FileOutputStream(file2));
        }
        catch (IOException iOException) {
            logger.warning("Unable to convert:" + iOException);
            return;
        }
        logger.info("Conversion complete!");
    }

    public void setProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public void clearProperty(String string) {
        this.properties.remove(string);
    }
}

