/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.converters.maxutils;

import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jmex.model.converters.maxutils.ChunkHeader;
import com.jmex.model.converters.maxutils.ChunkerClass;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

class KeyframeInfoChunk
extends ChunkerClass {
    private static final Logger logger = Logger.getLogger(KeyframeInfoChunk.class.getName());
    static final int INSTANCE_NAME = 45073;
    String name;
    short parent;
    short myID;
    Vector3f pivot;
    ArrayList<KeyPointInTime> track;
    float morphSmoothAngle;
    Vector3f BBoxMin;
    Vector3f BBoxMax;

    public KeyframeInfoChunk(DataInput dataInput, ChunkHeader chunkHeader) throws IOException {
        super(dataInput, chunkHeader);
    }

    protected void initializeVariables() throws IOException {
        this.track = new ArrayList();
    }

    protected boolean processChildChunk(ChunkHeader chunkHeader) throws IOException {
        switch (chunkHeader.type) {
            case 45104: {
                this.readNodeID();
                return true;
            }
            case 45072: {
                this.readTrackHeader();
                return true;
            }
            case 45075: {
                this.readTrackPivot();
                return true;
            }
            case 45088: {
                this.readPosTrackTag();
                return true;
            }
            case 45089: {
                this.readRotTrackTag();
                return true;
            }
            case 45090: {
                this.readScaleTrackTag();
                return true;
            }
            case 45077: {
                this.readSmoothMorph();
                return true;
            }
            case 45091: {
                this.readFOVTrack();
                return true;
            }
            case 45092: {
                this.readRollTrack();
                return true;
            }
            case 45093: {
                this.readColorTrack();
                return true;
            }
            case 45095: {
                this.readHotspotTrack();
                return true;
            }
            case 45096: {
                this.readFalloffTrack();
                return true;
            }
            case 45076: {
                this.readBoundingBox();
                return true;
            }
            case 45073: {
                this.name = this.readcStr();
                return true;
            }
        }
        return false;
    }

    private void readBoundingBox() throws IOException {
        if (this.BBoxMin != null) {
            throw new IOException("logic error, BBoxMin not null:" + this.BBoxMin);
        }
        this.BBoxMin = new Vector3f(this.myIn.readFloat(), this.myIn.readFloat(), this.myIn.readFloat());
        this.BBoxMax = new Vector3f(this.myIn.readFloat(), this.myIn.readFloat(), this.myIn.readFloat());
    }

    private void readFalloffTrack() throws IOException {
        short s = this.myIn.readShort();
        long l = this.myIn.readLong();
        int n = this.myIn.readInt();
        for (int i = 0; i < n; ++i) {
            int n2 = this.myIn.readInt();
            short s2 = this.myIn.readShort();
            this.locateTrack((int)n2).fallOff = this.myIn.readFloat();
        }
    }

    private void readHotspotTrack() throws IOException {
        short s = this.myIn.readShort();
        long l = this.myIn.readLong();
        int n = this.myIn.readInt();
        for (int i = 0; i < n; ++i) {
            int n2 = this.myIn.readInt();
            short s2 = this.myIn.readShort();
            this.locateTrack((int)n2).hotSpot = this.myIn.readFloat();
        }
    }

    private void readColorTrack() throws IOException {
        short s = this.myIn.readShort();
        long l = this.myIn.readLong();
        int n = this.myIn.readInt();
        for (int i = 0; i < n; ++i) {
            int n2 = this.myIn.readInt();
            short s2 = this.myIn.readShort();
            this.locateTrack((int)n2).colorTrack = new ColorRGBA(this.myIn.readFloat(), this.myIn.readFloat(), this.myIn.readFloat(), 1.0f);
        }
    }

    private void readRollTrack() throws IOException {
        short s = this.myIn.readShort();
        long l = this.myIn.readLong();
        int n = this.myIn.readInt();
        for (int i = 0; i < n; ++i) {
            int n2 = this.myIn.readInt();
            short s2 = this.myIn.readShort();
            this.locateTrack((int)n2).roll = this.myIn.readFloat();
        }
    }

    private void readFOVTrack() throws IOException {
        short s = this.myIn.readShort();
        long l = this.myIn.readLong();
        int n = this.myIn.readInt();
        for (int i = 0; i < n; ++i) {
            int n2 = this.myIn.readInt();
            short s2 = this.myIn.readShort();
            this.locateTrack((int)n2).FOV = this.myIn.readFloat();
        }
    }

    private void readSmoothMorph() throws IOException {
        this.morphSmoothAngle = this.myIn.readFloat();
    }

    private void readScaleTrackTag() throws IOException {
        short s = this.myIn.readShort();
        long l = this.myIn.readLong();
        int n = this.myIn.readInt();
        for (int i = 0; i < n; ++i) {
            Vector3f vector3f;
            int n2 = this.myIn.readInt();
            short s2 = this.myIn.readShort();
            this.locateTrack((int)n2).scale = vector3f = new Vector3f(this.myIn.readFloat(), this.myIn.readFloat(), this.myIn.readFloat());
        }
    }

    private void readRotTrackTag() throws IOException {
        short s = this.myIn.readShort();
        long l = this.myIn.readLong();
        int n = this.myIn.readInt();
        Vector3f vector3f = new Vector3f();
        Quaternion quaternion = null;
        for (int i = 0; i < n; ++i) {
            int n2 = this.myIn.readInt();
            short s2 = this.myIn.readShort();
            float f = this.myIn.readFloat();
            f *= -1.0f;
            vector3f.x = this.myIn.readFloat();
            vector3f.y = this.myIn.readFloat();
            vector3f.z = this.myIn.readFloat();
            vector3f.normalizeLocal();
            Quaternion quaternion2 = new Quaternion();
            quaternion2.fromAngleNormalAxis(f, vector3f);
            if (i != 0) {
                quaternion2 = quaternion.mult(quaternion2);
            }
            quaternion = quaternion2;
            this.locateTrack((int)n2).rot = quaternion2;
        }
    }

    private void readPosTrackTag() throws IOException {
        short s = this.myIn.readShort();
        long l = this.myIn.readLong();
        int n = this.myIn.readInt();
        for (int i = 0; i < n; ++i) {
            int n2 = this.myIn.readInt();
            short s2 = this.myIn.readShort();
            this.locateTrack((int)n2).position = new Vector3f(this.myIn.readFloat(), this.myIn.readFloat(), this.myIn.readFloat());
            if (!DEBUG) continue;
            logger.info("trackPos#" + n2 + "Pos#i" + this.locateTrack((int)n2).position);
        }
    }

    private KeyPointInTime locateTrack(int n) {
        if (this.track.size() == 0) {
            KeyPointInTime keyPointInTime = new KeyPointInTime();
            keyPointInTime.frame = n;
            this.track.add(keyPointInTime);
            return keyPointInTime;
        }
        Object[] objectArray = this.track.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            if (((KeyPointInTime)objectArray[i]).frame > n) {
                KeyPointInTime keyPointInTime = new KeyPointInTime();
                keyPointInTime.frame = n;
                this.track.add(i, keyPointInTime);
                return keyPointInTime;
            }
            if (((KeyPointInTime)objectArray[i]).frame != n) continue;
            return this.track.get(i);
        }
        KeyPointInTime keyPointInTime = new KeyPointInTime();
        keyPointInTime.frame = n;
        this.track.add(keyPointInTime);
        return keyPointInTime;
    }

    private void readTrackPivot() throws IOException {
        this.pivot = new Vector3f(this.myIn.readFloat(), this.myIn.readFloat(), this.myIn.readFloat());
        if (DEBUG) {
            logger.info("Pivot of:" + this.pivot);
        }
    }

    private void readTrackHeader() throws IOException {
        this.name = this.readcStr();
        short s = this.myIn.readShort();
        short s2 = this.myIn.readShort();
        this.parent = this.myIn.readShort();
        if (DEBUG || DEBUG_LIGHT) {
            logger.info("Name:" + this.name + " with parent:" + this.parent);
        }
    }

    private void readNodeID() throws IOException {
        this.myID = this.myIn.readShort();
    }

    public class KeyPointInTime {
        public int frame;
        public Vector3f position;
        public Quaternion rot;
        public Vector3f scale;
        public float FOV;
        public float roll;
        public String morphName;
        public float hotSpot;
        public float fallOff;
        public ColorRGBA colorTrack;
    }
}

