/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.client.sample;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import jp.sourceforge.mmosf.client.sample.InputProcess;
import jp.sourceforge.mmosf.client.sample.JMessageLabel;
import jp.sourceforge.mmosf.client.sample.PacketProcess;
import jp.sourceforge.mmosf.client.sample.jme.LoggingResponseTime;
import jp.sourceforge.mmosf.server.level.GeomapData;
import jp.sourceforge.mmosf.server.object.ChatMessage;
import jp.sourceforge.mmosf.server.object.Mob;
import jp.sourceforge.mmosf.server.packet.Packet;
import jp.sourceforge.mmosf.server.packet.PacketFactory;
import jp.sourceforge.mmosf.server.packet.PacketFormatException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleClientFrame
extends JFrame
implements ActionListener,
LoggingResponseTime {
    static Log log = LogFactory.getLog(SampleClientFrame.class);
    protected long time;
    protected long timeMove;
    protected StringBuffer timelogBuffer;
    protected final int SIZE_TIMELOG_BFFER = 256;
    private static final long serialVersionUID = -5938590566332483922L;
    protected JMessageLabel message;
    protected JTextField input;
    public PacketProcess process;
    public InputProcess inputProcess;
    public MapManeger mmaneg;
    protected JLabel map;

    public SampleClientFrame() {
        this.setTitle("Sample Client");
        this.setBounds(10, 10, 400, 300);
        this.message = new JMessageLabel();
        JScrollPane scroll = new JScrollPane(this.message, 22, 31);
        this.input = new JTextField(10);
        this.mmaneg = new MapManeger();
        this.map = new JLabel();
        Font font = new Font("MS \u30b4\u30b7\u30c3\u30af", 0, 8);
        this.map.setFont(font);
        BorderLayout layout = new BorderLayout();
        JPanel panel = new JPanel();
        panel.setLayout(layout);
        panel.add((Component)this.input, "South");
        panel.add((Component)scroll, "Center");
        panel.add((Component)this.map, "West");
        this.getContentPane().add((Component)panel, "Center");
        this.getMessage().setVerticalAlignment(1);
        this.inputProcess = new InputProcess(){

            public void send(Packet packet) {
                SampleClientFrame.this.process.send(packet);
            }

            public boolean isLogout() {
                return SampleClientFrame.this.process.isLogout();
            }
        };
        this.input.addKeyListener(this.inputProcess);
        this.process = new PacketProcess(){

            @Override
            public void receiveMessage(ChatMessage message) {
                SampleClientFrame.this.getMessage().addMessage(message);
            }

            @Override
            public void receiveUpdate(Mob self, List<Mob> listUpdate, List<Mob> listDelete) {
                SampleClientFrame.this.update(self, listUpdate);
            }

            @Override
            public void receivePacket(Packet packet) {
            }
        };
        this.process.setFrame(this);
        this.getInput().addActionListener(this);
    }

    public void update(Mob self, List<Mob> listUpdate) {
        StringBuffer buff = this.mmaneg.update2(self, listUpdate);
        this.map.setText(buff.toString());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String str = this.getInput().getText();
        this.process.sendMessage(str);
        this.getInput().setText("");
    }

    public JMessageLabel getMessage() {
        return this.message;
    }

    public JLabel getMap() {
        return this.map;
    }

    public JTextField getInput() {
        return this.input;
    }

    public void start() {
        this.process.start();
    }

    public boolean connect(SocketAddress addr, String connectId) throws InterruptedException, IOException, PacketFormatException {
        return this.process.connect(addr, connectId);
    }

    @Override
    public void startLogTimeMove() {
        if (!this.isTime()) {
            return;
        }
        this.timeMove = System.nanoTime();
    }

    @Override
    public void startLogTime() {
        if (!this.isTime()) {
            return;
        }
        this.time = System.nanoTime();
    }

    @Override
    public void logTimeMove() {
        if (!this.isTime()) {
            return;
        }
        if (this.timeMove == 0L) {
            return;
        }
        long timePast = System.nanoTime() - this.timeMove;
        this.logTime("move:" + (double)timePast / 1.0E9);
        this.timeMove = 0L;
    }

    @Override
    public void logTime(Packet packet) throws PacketFormatException {
        if (!this.isTime()) {
            return;
        }
        long timePast = System.nanoTime() - this.time;
        this.logTime("past(" + packet.getType() + "):" + (double)timePast / 1.0E9);
    }

    protected boolean isTime() {
        return true;
    }

    protected void logTime(String string) {
        this.timelogBuffer.append(String.valueOf(string) + ";");
        if (this.timelogBuffer.length() < 256) {
            return;
        }
        this.sendLog();
    }

    @Override
    public void sendLog() {
        if (!this.isTime()) {
            return;
        }
        Packet pac = PacketFactory.createLogPacket(this.timelogBuffer.toString());
        this.process.send(pac);
        this.timelogBuffer.setLength(0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MapManeger {
        protected GeomapData zone = new GeomapData();

        MapManeger() {
        }

        protected int getOffset(int pos, int viewSize, int mapSize) {
            int Offset = pos - viewSize / 2;
            if (Offset < 0) {
                Offset = 0;
            } else if (Offset > mapSize - viewSize) {
                Offset = mapSize - viewSize;
            }
            return Offset;
        }

        char[][] getMapChar(int xPos, int yPos, int xSize, int ySize) {
            char[][] map = new char[ySize][xSize];
            int i = 0;
            while (i < ySize) {
                int j = 0;
                while (j < xSize) {
                    map[i][j] = this.zone.map[yPos + i][xPos + j];
                    ++j;
                }
                ++i;
            }
            return map;
        }

        StringBuffer update2(Mob self, List<Mob> listMob) {
            int ySize = 20;
            int xSize = 20;
            int yLimit = this.zone.getMapHeight();
            int xLimit = this.zone.getMapWidth();
            int yOffset = this.getOffset(self.moving.getPosition().getY(), ySize, yLimit);
            int xOffset = this.getOffset(self.moving.getPosition().getX(), xSize, xLimit);
            char[][] map = this.getMapChar(xOffset, yOffset, xSize, ySize);
            for (Mob mob : listMob) {
                int y2 = mob.moving.getPosition().getY() - yOffset;
                int x2 = mob.moving.getPosition().getX() - xOffset;
                if (y2 < 0 || y2 >= map.length || x2 < 0 || x2 >= map[0].length) continue;
                map[y2][x2] = mob.c;
            }
            StringBuffer buff = new StringBuffer();
            buff.append("<html>");
            int i = 0;
            while (i < map.length) {
                buff.append(map[i]);
                buff.append("<br>");
                ++i;
            }
            buff.append("</html>");
            return buff;
        }
    }
}

