/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server.object;

import jp.sourceforge.mmosf.server.Perception;
import jp.sourceforge.mmosf.server.object.MoveObject;
import jp.sourceforge.mmosf.server.object.Position;
import jp.sourceforge.mmosf.server.object.Vector;

public abstract class Moving {
    protected static final String SPEED = "speed";
    protected static final String DIRECTION = "direction";
    protected static final String VECTOR = "vector";
    protected static final String POSITION = "position";
    public static final int COL_NO = 0;
    public static final int COL_ALL = 1;
    public static final int COL_PC = 2;
    public static final int COL_NPC = 3;
    public static final int MOVE_RND = 2;
    public static final int MOVE_VECTOR = 1;
    public static final int MOVE_NO = 0;
    protected int moveType;
    protected double speed;
    private Position pos;
    private Vector direction;
    protected long nowTime;
    protected long lastTime;
    private int colType = 1;

    Moving(Position pos) {
        this.pos = pos;
        this.direction = Vector.EAST;
    }

    public boolean isMoveType(int moveType) {
        return this.moveType == moveType;
    }

    public abstract MoveObject createMoveObject();

    public abstract void move(Perception var1);

    public double getSpeed() {
        return this.speed;
    }

    public abstract Vector getVector();

    public Position getPosition() {
        return this.pos;
    }

    public void setPosition(Position pos) {
        this.pos = pos;
    }

    public void setColType(int colType) {
        this.colType = colType;
    }

    public int getColType() {
        return this.colType;
    }

    public boolean isColType(int colType) {
        return this.colType == colType;
    }

    public boolean isCollision(MoveObject mo) {
        if (this.isColType(0)) {
            return false;
        }
        return this.getPosition().equals(mo.getNextPos());
    }

    public boolean isEnableMove(MoveObject mo, Perception prc) {
        if (mo.getVec().isZero()) {
            return false;
        }
        if (this.getPosition().equals(mo.getNextPos())) {
            return true;
        }
        return prc.isEnableMove(mo);
    }

    public void setDirection(Vector direction) {
        if (direction.isZero()) {
            return;
        }
        this.direction = direction;
    }

    public Vector getDirection() {
        return this.direction;
    }

    public abstract Moving duplicate();

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(POSITION);
        sb.append("{");
        sb.append(this.getPosition().toString());
        sb.append("};");
        sb.append(VECTOR);
        sb.append("{");
        sb.append(this.getVector().toString());
        sb.append("};");
        sb.append(DIRECTION);
        sb.append("{");
        sb.append(this.getDirection().toString());
        sb.append("};");
        sb.append(SPEED);
        sb.append("{");
        sb.append(Double.toString(this.getSpeed()));
        sb.append("}");
        return sb.toString();
    }

    public String toString2() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getPosition().toString2());
        sb.append(";");
        sb.append(this.getVector().toString2());
        sb.append(";");
        sb.append(this.getDirection().toString2());
        sb.append(";");
        sb.append(Double.toString(this.getSpeed()));
        return sb.toString();
    }

    public void updateTime(long time) {
        this.lastTime = this.nowTime;
        this.nowTime = time;
    }
}

