/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server.object;

import jp.sourceforge.mmosf.admin.MobMonitor;
import jp.sourceforge.mmosf.server.Perception;
import jp.sourceforge.mmosf.server.object.Moving;
import jp.sourceforge.mmosf.server.object.MovingVector;
import jp.sourceforge.mmosf.server.object.Position;
import jp.sourceforge.mmosf.server.object.Vector;

public class MovingInputVector
extends MovingVector {
    private Vector cacheVec = super.getVector();
    private boolean isMove = false;
    private boolean isStop = false;

    public MovingInputVector(Position pos) {
        super(pos);
    }

    protected synchronized void onMoved() {
        this.isMove = true;
        if (this.isStop) {
            this.isStop = false;
            this.cacheVec = Vector.ZERO;
            super.setVector(Vector.ZERO);
            MobMonitor.getMonitor().log("mob stop");
        }
    }

    protected synchronized void onStop() {
        this.isMove = true;
        if (this.isStop) {
            this.isStop = false;
            this.cacheVec = Vector.ZERO;
            super.setVector(Vector.ZERO);
        }
    }

    public synchronized void setVector(Vector vec) {
        if (vec.isZero()) {
            if (this.isMove) {
                super.setVector(vec);
                this.cacheVec = vec;
            } else {
                this.isStop = true;
            }
        } else {
            if (super.getVector().isZero()) {
                this.isMove = false;
            }
            this.cacheVec = vec;
        }
        this.normalize();
    }

    protected synchronized Vector getVector(Position nowPos) {
        return super.getVector(nowPos);
    }

    public synchronized void move(Perception prc) {
        super.setVector(this.cacheVec);
        super.move(prc);
    }

    public synchronized Moving duplicate() {
        MovingInputVector mv = new MovingInputVector(this.getPosition());
        mv.setColType(this.getColType());
        mv.setDirection(this.getDirection());
        mv.setSuperClassVector(this.getSuperClassVector());
        mv.cacheVec = this.cacheVec;
        mv.isMove = this.isMove;
        mv.isStop = this.isStop;
        mv.nowTime = this.nowTime;
        mv.lastTime = this.lastTime;
        return mv;
    }

    private void setSuperClassVector(Vector vec) {
        super.setVector(vec);
    }

    private Vector getSuperClassVector() {
        return super.getVector();
    }
}

