/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server.object;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import jp.sourceforge.mmosf.server.UserConnection;
import jp.sourceforge.mmosf.server.object.Mob;
import jp.sourceforge.mmosf.server.object.MovingInputVector;
import jp.sourceforge.mmosf.server.object.MovingVector;
import jp.sourceforge.mmosf.server.object.UpdateCache;
import jp.sourceforge.mmosf.server.object.Vector;
import jp.sourceforge.mmosf.server.object.item.Item;
import jp.sourceforge.mmosf.server.object.quest.Quest;
import jp.sourceforge.mmosf.server.packet.Packet;
import jp.sourceforge.mmosf.server.packet.PacketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayerCharactor
extends Mob {
    private static Log log = LogFactory.getLog(PlayerCharactor.class);
    public UserConnection conn;
    protected UpdateCache cache = null;
    private Item[] listItem;
    public Quest[] listQuest;
    public List<Quest> listCompleteQuest;
    private BlockingQueue<Vector> queueMove;
    private static final int QUEUE_SIZE = 3;

    public PlayerCharactor(int x, int y, Character c, int id, UserConnection conn) {
        super(x, y, c, id, 1);
        this.conn = conn;
        this.cache = new UpdateCache();
        this.moving = new MovingInputVector(this.moving.getPosition());
        this.listItem = new Item[20];
        this.listQuest = new Quest[20];
        this.listCompleteQuest = new LinkedList<Quest>();
        this.queueMove = new LinkedBlockingQueue<Vector>();
    }

    public PlayerCharactor(PlayerCharactor mob) {
        super(mob);
        this.conn = mob.conn;
        this.cache = new UpdateCache();
        this.moving = new MovingInputVector(this.moving.getPosition());
    }

    @Override
    public boolean isPlayerCharactor() {
        return true;
    }

    public void sendUpdate(List<Mob> listMob) {
        LinkedList<Mob> listUpdate = new LinkedList<Mob>();
        LinkedList<Mob> listDelete = new LinkedList<Mob>();
        this.cache.pickUpdate(listMob, listUpdate, listDelete);
        if (log.isTraceEnabled()) {
            if (listUpdate.size() > 0) {
                log.trace("update");
            }
            for (Mob mob : listUpdate) {
                log.trace(mob.toString());
            }
            if (listDelete.size() > 0) {
                log.trace("delete");
            }
            for (Mob mob : listDelete) {
                log.trace(mob.toString());
            }
        }
        Packet pac = PacketFactory.createUpdatePacket(listUpdate, listDelete);
        try {
            this.conn.send(pac);
        }
        catch (Exception e) {
            log.error(e);
        }
    }

    public void setVector(Vector v) {
        ((MovingVector)this.moving).setVector(v);
    }

    public int addItem(Item item) {
        int i = 0;
        while (i < this.listItem.length) {
            if (this.listItem[i] == null) {
                this.listItem[i] = item;
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int addQuest(Quest quest) {
        int i = 0;
        while (i < this.listQuest.length) {
            if (this.listQuest[i] == null) {
                this.listQuest[i] = quest;
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getQuestIndex(int id) {
        int i = 0;
        while (i < this.listQuest.length) {
            if (this.listQuest[i] != null && this.listQuest[i].id == id) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getItemIndex(int itemId) {
        int i = 0;
        while (i < this.listItem.length) {
            if (this.listItem[i] != null && this.listItem[i].id == itemId) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Quest getQuest(int index) {
        return this.listQuest[index];
    }

    public Item getItem(int index) {
        return this.listItem[index];
    }

    public boolean setMoveQueue(Vector vec) {
        block6: {
            block5: {
                try {
                    if (!vec.isZero()) break block5;
                    if (this.queueMove.size() > 3) {
                        log.trace("flood queue.");
                        return false;
                    }
                    break block6;
                }
                catch (InterruptedException e) {
                    log.error("error in setMoveQueue", e);
                    return false;
                }
            }
            if (this.queueMove.size() < 3) break block6;
            log.trace("flood queue.");
            return false;
        }
        this.queueMove.put(vec);
        log.trace("set queue " + vec.toString());
        return true;
    }

    public Vector getMoveQueue() {
        if (this.queueMove.isEmpty()) {
            return null;
        }
        try {
            Vector vec = this.queueMove.take();
            log.trace("get queue " + vec.toString());
            return vec;
        }
        catch (InterruptedException e) {
            log.error("error in getMoveQueue", e);
            return null;
        }
    }
}

