/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server.packet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jp.sourceforge.mmosf.server.packet.PacketFormatException;
import jp.sourceforge.mmosf.server.packet.PacketFormatter;
import jp.sourceforge.mmosf.server.packet.Type;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlPacketFormatter
implements PacketFormatter {
    private static final String SEPARATOR = ".";
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    private static final String ROOT_NAME = "packet";
    private Type type = new Type();
    private Document document = null;
    private Element rootElement = null;
    private static DocumentBuilder builder = null;
    private static DocumentBuilderFactory factory = null;
    private static Transformer transformer = null;
    private static TransformerFactory factory2 = null;

    XmlPacketFormatter() {
    }

    public void create(int type) throws PacketFormatException {
        try {
            this.document = XmlPacketFormatter.getDocumentBuilder().newDocument();
            this.rootElement = this.document.createElement(ROOT_NAME);
            this.document.appendChild(this.rootElement);
            this.rootElement.setAttribute("ID", Integer.toString(type));
            this.rootElement.setAttribute("name", this.type.getPacketClassName(type));
        }
        catch (Exception e) {
            throw new PacketFormatException("xml create error.", e);
        }
    }

    public void parse(ByteBuffer buff) throws PacketFormatException {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(buff.array());
            this.document = XmlPacketFormatter.getDocumentBuilder().parse(bais);
            this.rootElement = this.document.getDocumentElement();
        }
        catch (Exception e) {
            throw new PacketFormatException("xml parse error.", e);
        }
    }

    public int getType() throws PacketFormatException {
        try {
            return Integer.parseInt(this.rootElement.getAttribute("ID"));
        }
        catch (Exception e) {
            throw new PacketFormatException("xml parse error.", e);
        }
    }

    public ByteBuffer toBytes() throws PacketFormatException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XmlPacketFormatter.getTransformer().transform(new DOMSource(this.document), new StreamResult(baos));
            baos.flush();
            return ByteBuffer.wrap(baos.toByteArray());
        }
        catch (Exception e) {
            throw new PacketFormatException("xml format error.", e);
        }
    }

    protected static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        if (factory == null) {
            factory = DocumentBuilderFactory.newInstance();
        }
        if (builder == null) {
            builder = factory.newDocumentBuilder();
        }
        return builder;
    }

    protected static Transformer getTransformer() throws TransformerConfigurationException {
        if (factory2 == null) {
            factory2 = TransformerFactory.newInstance();
        }
        if (transformer == null) {
            transformer = factory2.newTransformer();
        }
        return transformer;
    }

    public int getInt(String name) throws PacketFormatException {
        try {
            String value = this.getString(name);
            if (value == null) {
                throw new PacketFormatException("not found formatter type.");
            }
            Integer i = new Integer(value);
            return i;
        }
        catch (NumberFormatException e) {
            throw new PacketFormatException("bad format formatter type.", e);
        }
    }

    public String getString(String name) throws PacketFormatException {
        NodeList list = this.rootElement.getElementsByTagName(name);
        Node node = list.item(0);
        if (node == null) {
            return null;
        }
        return node.getFirstChild().getNodeValue();
    }

    public void setInt(String name, int value) {
        String str = Integer.toString(value);
        this.setString(name, str);
    }

    public void setString(String name, String value) {
        Element newElm = null;
        NodeList list = this.rootElement.getElementsByTagName(name);
        newElm = (Element)list.item(0);
        if (newElm == null) {
            newElm = this.document.createElement(name);
        }
        newElm = this.document.createElement(name);
        newElm.appendChild(this.document.createTextNode(value));
        this.rootElement.appendChild(newElm);
    }

    public boolean getBoolean(String name) throws PacketFormatException {
        String str = this.getString(name);
        if (str.equalsIgnoreCase(TRUE)) {
            return true;
        }
        if (str.equalsIgnoreCase(FALSE)) {
            return false;
        }
        throw new PacketFormatException("bad boolean value.");
    }

    public void setBoolean(String name, boolean value) {
        if (value) {
            this.setString(name, TRUE);
        } else {
            this.setString(name, FALSE);
        }
    }

    public int getInt(String name1, String name2) throws PacketFormatException {
        return this.getInt(String.valueOf(name1) + SEPARATOR + name2);
    }

    public String getString(String name1, String name2) throws PacketFormatException {
        return this.getString(String.valueOf(name1) + SEPARATOR + name2);
    }

    public void setInt(String name1, String name2, int value) {
        this.setInt(String.valueOf(name1) + SEPARATOR + name2, value);
    }

    public void setString(String name1, String name2, String value) {
        this.setString(String.valueOf(name1) + SEPARATOR + name2, value);
    }

    public double getDouble(String name1, String name2) throws PacketFormatException {
        return this.getDouble(String.valueOf(name1) + SEPARATOR + name2);
    }

    public double getDouble(String name) throws PacketFormatException {
        try {
            String value = this.getString(name);
            if (value == null) {
                throw new PacketFormatException("not found formatter type.");
            }
            return Double.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new PacketFormatException("bad format formatter type.", e);
        }
    }

    public void setDouble(String name, double value) {
        String str = Double.toString(value);
        this.setString(name, str);
    }

    public void setDouble(String name1, String name2, double value) {
        this.setDouble(String.valueOf(name1) + SEPARATOR + name2, value);
    }
}

