/*
 * Decompiled with CFR 0.152.
 */
package com.jme.input;

import com.jme.input.KeyInput;
import java.util.ArrayList;
import java.util.HashMap;

public class KeyBindingManager {
    private static KeyBindingManager instance = null;
    private HashMap<String, ArrayList<KeyCodes>> keyMap;
    private boolean[] restrictKey = new boolean[256];

    private KeyBindingManager() {
        this.keyMap = new HashMap();
    }

    public void set(String string, int n) {
        ArrayList<KeyCodes> arrayList = new ArrayList<KeyCodes>();
        KeyCodes keyCodes = new KeyCodes();
        keyCodes.keys = new int[1];
        keyCodes.keys[0] = n;
        arrayList.add(keyCodes);
        this.keyMap.put(string, arrayList);
    }

    public void set(String string, int[] nArray) {
        ArrayList<KeyCodes> arrayList = new ArrayList<KeyCodes>();
        KeyCodes keyCodes = new KeyCodes();
        keyCodes.keys = nArray;
        arrayList.add(keyCodes);
        this.keyMap.put(string, arrayList);
    }

    public void add(String string, int n) {
        ArrayList<KeyCodes> arrayList = this.keyMap.get(string);
        if (null == arrayList) {
            this.set(string, n);
            return;
        }
        KeyCodes keyCodes = new KeyCodes();
        keyCodes.keys = new int[1];
        keyCodes.keys[0] = n;
        arrayList.add(keyCodes);
    }

    public void add(String string, int[] nArray) {
        ArrayList<KeyCodes> arrayList = this.keyMap.get(string);
        if (null == arrayList) {
            this.set(string, nArray);
            return;
        }
        KeyCodes keyCodes = new KeyCodes();
        keyCodes.keys = nArray;
        arrayList.add(keyCodes);
    }

    public int[] get(String string, int n) {
        return this.keyMap.get((Object)string).get((int)n).keys;
    }

    public boolean isValidCommand(String string) {
        return this.isValidCommand(string, true);
    }

    public boolean isValidCommand(String string, boolean bl) {
        ArrayList<KeyCodes> arrayList = this.keyMap.get(string);
        if (null == arrayList) {
            return false;
        }
        if (arrayList.isEmpty()) {
            return true;
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            int[] nArray = arrayList.get((int)i).keys;
            boolean bl2 = true;
            for (int j = 0; bl2 && j < nArray.length; ++j) {
                bl2 = bl ? KeyInput.get().isKeyDown(nArray[j]) : this.getStickyKey(nArray[j]);
            }
            if (!bl2) continue;
            return true;
        }
        return false;
    }

    private boolean getStickyKey(int n) {
        if (!this.restrictKey[n] && KeyInput.get().isKeyDown(n)) {
            this.restrictKey[n] = true;
            return true;
        }
        if (!KeyInput.get().isKeyDown(n) && this.restrictKey[n]) {
            this.restrictKey[n] = false;
        }
        return false;
    }

    public void remove(String string) {
        this.keyMap.remove(string);
    }

    public static KeyBindingManager getKeyBindingManager() {
        if (null == instance) {
            instance = new KeyBindingManager();
        }
        return instance;
    }

    public class KeyCodes {
        public int[] keys;
    }
}

