/*
 * Decompiled with CFR 0.152.
 */
package com.jme.input.lwjgl;

import com.jme.image.Image;
import com.jme.input.MouseInput;
import com.jme.input.MouseInputListener;
import com.jme.system.lwjgl.LWJGLStandardCursor;
import com.jme.util.TextureManager;
import java.net.URL;
import java.nio.IntBuffer;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Cursor;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;

public class LWJGLMouseInput
extends MouseInput {
    private static final Logger logger = Logger.getLogger(LWJGLMouseInput.class.getName());
    private static Hashtable<URL, Cursor> loadedCursors;
    private int dx;
    private int dy;
    private int lastX;
    private int lastY;
    private boolean virgin = true;
    private int dWheel;
    private int wheelRotation;

    protected LWJGLMouseInput() {
        try {
            Mouse.create();
            this.setCursorVisible(false);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Problem during creation of Mouse.", exception);
        }
    }

    public void destroy() {
        this.setCursorVisible(false);
        Mouse.destroy();
    }

    public int getButtonIndex(String string) {
        return Mouse.getButtonIndex((String)string);
    }

    public String getButtonName(int n) {
        return Mouse.getButtonName((int)n);
    }

    public boolean isButtonDown(int n) {
        return Mouse.isButtonDown((int)n);
    }

    public int getWheelDelta() {
        return this.dWheel;
    }

    public int getXDelta() {
        return this.dx;
    }

    public int getYDelta() {
        return this.dy;
    }

    public int getXAbsolute() {
        return Mouse.getX();
    }

    public int getYAbsolute() {
        return Mouse.getY();
    }

    public void update() {
        if (Display.isActive()) {
            int n;
            int n2;
            boolean bl = Mouse.isGrabbed();
            if (bl) {
                this.dx = Mouse.getDX();
                this.dy = Mouse.getDY();
                n2 = Mouse.getX();
                n = Mouse.getY();
            } else {
                n2 = Mouse.getEventX();
                n = Mouse.getEventY();
                this.dx = n2 - this.lastX;
                this.dy = n - this.lastY;
                this.lastX = n2;
                this.lastY = n;
            }
            if (this.virgin && (this.dx != 0 || this.dy != 0)) {
                this.dy = 0;
                this.dx = 0;
                this.wheelRotation = 0;
                this.virgin = false;
            }
            this.dWheel = Mouse.getDWheel();
            this.wheelRotation += this.dWheel;
            if (this.listeners != null && this.listeners.size() > 0) {
                while (Mouse.next()) {
                    int n3 = Mouse.getEventButton();
                    boolean bl2 = n3 >= 0 && Mouse.getEventButtonState();
                    int n4 = Mouse.getEventDWheel();
                    int n5 = Mouse.getEventDX();
                    int n6 = Mouse.getEventDY();
                    for (int i = 0; i < this.listeners.size(); ++i) {
                        MouseInputListener mouseInputListener = (MouseInputListener)this.listeners.get(i);
                        if (n3 >= 0) {
                            mouseInputListener.onButton(n3, bl2, n2, n);
                        }
                        if (n4 != 0) {
                            mouseInputListener.onWheel(n4, n2, n);
                        }
                        if (n5 == 0 && n6 == 0) continue;
                        mouseInputListener.onMove(n5, n6, n2, n);
                    }
                }
                return;
            }
        }
        while (Mouse.next()) {
        }
    }

    public void setCursorVisible(boolean bl) {
        Mouse.setGrabbed((!bl ? 1 : 0) != 0);
        try {
            if (bl) {
                Mouse.setNativeCursor((Cursor)LWJGLStandardCursor.cursor);
            } else {
                Mouse.setNativeCursor(null);
            }
        }
        catch (Exception exception) {
            logger.warning("Problem showing mouse cursor.");
        }
    }

    public boolean isCursorVisible() {
        return Mouse.getNativeCursor() != null;
    }

    public void setHardwareCursor(URL uRL) {
        this.setHardwareCursor(uRL, -1, -1);
    }

    public void setHardwareCursor(URL uRL, int n, int n2) {
        Mouse.setGrabbed((boolean)false);
        if (loadedCursors == null) {
            loadedCursors = new Hashtable();
        }
        Cursor cursor = null;
        if (loadedCursors.containsKey(uRL)) {
            cursor = loadedCursors.get(uRL);
        } else {
            boolean bl = true;
            if ((Cursor.getCapabilities() & 2) == 0) {
                bl = false;
            }
            Image image = TextureManager.loadImage(uRL, true);
            IntBuffer intBuffer = image.getData().asIntBuffer();
            IntBuffer intBuffer2 = BufferUtils.createIntBuffer((int)intBuffer.remaining());
            int n3 = image.getWidth();
            int n4 = image.getHeight();
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    int n5 = i * n3 + j;
                    int n6 = intBuffer.get(n5);
                    int n7 = n6 >> 24 & 0xFF;
                    int n8 = n6 >> 16 & 0xFF;
                    int n9 = n6 >> 8 & 0xFF;
                    int n10 = n6 & 0xFF;
                    if (!bl) {
                        if (n7 < 127) {
                            n7 = 0;
                            n8 = 0;
                            n9 = 0;
                            n10 = 0;
                        } else {
                            n7 = 255;
                        }
                    }
                    intBuffer2.put(n5, n7 << 24 | n10 << 16 | n9 << 8 | n8);
                }
            }
            if (n < 0 || n2 < 0 || n >= n3 || n2 >= n4) {
                n = 0;
                n2 = n4 - 1;
                logger.warning("Hotspot positions are outside image bounds!");
            }
            try {
                cursor = new Cursor(n3, n4, n, n2, 1, intBuffer2, null);
            }
            catch (LWJGLException lWJGLException) {
                logger.log(Level.WARNING, "Failed creating native cursor!", lWJGLException);
            }
            loadedCursors.put(uRL, cursor);
        }
        try {
            Mouse.setNativeCursor((Cursor)cursor);
        }
        catch (LWJGLException lWJGLException) {
            logger.log(Level.WARNING, "Failed setting native cursor!", lWJGLException);
        }
    }

    public void setHardwareCursor(URL uRL, Image[] imageArray, int[] nArray, int n, int n2) {
        Mouse.setGrabbed((boolean)false);
        if (loadedCursors == null) {
            loadedCursors = new Hashtable();
        }
        Cursor cursor = null;
        if (loadedCursors.containsKey(uRL)) {
            cursor = loadedCursors.get(uRL);
        } else {
            boolean bl = true;
            if ((Cursor.getCapabilities() & 2) == 0) {
                bl = false;
            }
            Image image = imageArray[0];
            int n3 = image.getWidth();
            int n4 = image.getHeight();
            IntBuffer intBuffer = image.getData().asIntBuffer();
            int n5 = intBuffer.remaining();
            IntBuffer intBuffer2 = BufferUtils.createIntBuffer((int)(n5 * imageArray.length));
            for (int i = 0; i < imageArray.length; ++i) {
                image = imageArray[i];
                intBuffer = image.getData().asIntBuffer();
                for (int j = 0; j < n4; ++j) {
                    for (int k = 0; k < n3; ++k) {
                        int n6 = j * n3 + k;
                        int n7 = intBuffer.get(n6);
                        int n8 = n7 >> 24 & 0xFF;
                        int n9 = n7 >> 16 & 0xFF;
                        int n10 = n7 >> 8 & 0xFF;
                        int n11 = n7 & 0xFF;
                        if (!bl) {
                            if (n8 < 127) {
                                n8 = 0;
                                n9 = 0;
                                n10 = 0;
                                n11 = 0;
                            } else {
                                n8 = 255;
                            }
                        }
                        intBuffer2.put(n6 + n5 * i, n8 << 24 | n11 << 16 | n10 << 8 | n9);
                    }
                }
            }
            if (n < 0 || n2 < 0 || n >= n3 || n2 >= n4) {
                n = 0;
                n2 = n4 - 1;
                logger.log(Level.WARNING, "Hotspot positions are outside image bounds!");
            }
            IntBuffer intBuffer3 = null;
            if (nArray != null) {
                intBuffer3 = BufferUtils.createIntBuffer((int)nArray.length);
                intBuffer3.put(nArray);
                intBuffer3.rewind();
            }
            try {
                cursor = new Cursor(n3, n4, n, n2, imageArray.length, intBuffer2, intBuffer3);
            }
            catch (LWJGLException lWJGLException) {
                logger.log(Level.WARNING, "Failed creating native cursor!", lWJGLException);
            }
            loadedCursors.put(uRL, cursor);
        }
        try {
            Mouse.setNativeCursor((Cursor)cursor);
        }
        catch (LWJGLException lWJGLException) {
            logger.log(Level.WARNING, "Failed setting native cursor!", lWJGLException);
        }
    }

    public int getWheelRotation() {
        return this.wheelRotation;
    }

    public int getButtonCount() {
        return Mouse.getButtonCount();
    }

    public void setCursorPosition(int n, int n2) {
        Mouse.setCursorPosition((int)n, (int)n2);
    }
}

