/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.state.lwjgl;

import com.jme.renderer.RenderContext;
import com.jme.scene.state.CullState;
import com.jme.scene.state.lwjgl.records.CullStateRecord;
import com.jme.system.DisplaySystem;
import org.lwjgl.opengl.GL11;

public class LWJGLCullState
extends CullState {
    private static final long serialVersionUID = 1L;

    public void apply() {
        RenderContext renderContext = DisplaySystem.getDisplaySystem().getCurrentContext();
        CullStateRecord cullStateRecord = (CullStateRecord)renderContext.getStateRecord(9);
        renderContext.currentStates[9] = this;
        if (this.isEnabled()) {
            int n = this.getCullMode();
            if (CullState.isFlippedCulling()) {
                if (n == 2) {
                    n = 1;
                } else if (n == 1) {
                    n = 2;
                }
            }
            switch (n) {
                case 1: {
                    this.setCull(1028, cullStateRecord);
                    this.setCullEnabled(true, cullStateRecord);
                    break;
                }
                case 2: {
                    this.setCull(1029, cullStateRecord);
                    this.setCullEnabled(true, cullStateRecord);
                    break;
                }
                case 3: {
                    this.setCull(1032, cullStateRecord);
                    this.setCullEnabled(true, cullStateRecord);
                    break;
                }
                default: {
                    this.setCullEnabled(false, cullStateRecord);
                    break;
                }
            }
        } else {
            this.setCullEnabled(false, cullStateRecord);
        }
        if (!cullStateRecord.isValid()) {
            cullStateRecord.validate();
        }
    }

    private void setCullEnabled(boolean bl, CullStateRecord cullStateRecord) {
        if (!cullStateRecord.isValid() || cullStateRecord.enabled != bl) {
            if (bl) {
                GL11.glEnable((int)2884);
            } else {
                GL11.glDisable((int)2884);
            }
            cullStateRecord.enabled = bl;
        }
    }

    private void setCull(int n, CullStateRecord cullStateRecord) {
        if (!cullStateRecord.isValid() || cullStateRecord.face != n) {
            GL11.glCullFace((int)n);
            cullStateRecord.face = n;
        }
    }

    public CullStateRecord createStateRecord() {
        return new CullStateRecord();
    }
}

