/*
 * Decompiled with CFR 0.152.
 */
package com.jme.system;

import com.jme.system.DisplaySystem;
import com.jme.system.JmeException;
import com.jme.system.PropertiesIO;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.DisplayMode;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;

public final class PropertiesDialog2
extends JDialog {
    private static final Logger logger = Logger.getLogger(PropertiesDialog2.class.getName());
    private static final long serialVersionUID = 1L;
    private final PropertiesIO source;
    private URL imageFile = null;
    private final DisplayMode[] modes;
    private JCheckBox fullscreenBox = null;
    private JComboBox displayResCombo = null;
    private JComboBox colorDepthCombo = null;
    private JComboBox displayFreqCombo = null;
    private JComboBox rendererCombo = null;
    private JLabel icon = null;

    public PropertiesDialog2(PropertiesIO propertiesIO, String string) {
        this(propertiesIO, PropertiesDialog2.getURL(string));
    }

    public PropertiesDialog2(PropertiesIO propertiesIO, URL uRL) {
        if (null == propertiesIO) {
            throw new JmeException("PropertyIO source cannot be null");
        }
        this.source = propertiesIO;
        this.imageFile = uRL;
        this.modes = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayModes();
        Arrays.sort(this.modes, new DisplayModeSorter());
        this.createUI();
    }

    public void setImage(String string) {
        try {
            URL uRL = new URL("file:" + string);
            this.setImage(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void setImage(URL uRL) {
        this.icon.setIcon(new ImageIcon(uRL));
        this.pack();
        this.center();
    }

    private void showDialog() {
        this.setVisible(true);
        this.toFront();
    }

    private void center() {
        int n = (Toolkit.getDefaultToolkit().getScreenSize().width - this.getWidth()) / 2;
        int n2 = (Toolkit.getDefaultToolkit().getScreenSize().height - this.getHeight()) / 2;
        this.setLocation(n, n2);
    }

    private void createUI() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            logger.warning("Could not set native look and feel.");
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PropertiesDialog2.this.dispose();
                System.exit(0);
            }
        });
        this.setTitle("Select Display Settings");
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JButton jButton = new JButton("Ok");
        JButton jButton2 = new JButton("Cancel");
        this.icon = new JLabel(new ImageIcon(this.imageFile));
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new BorderLayout());
        this.displayResCombo = this.setUpResolutionChooser();
        this.colorDepthCombo = new JComboBox();
        this.displayFreqCombo = new JComboBox();
        this.fullscreenBox = new JCheckBox("Fullscreen?");
        this.fullscreenBox.setSelected(this.source.getFullscreen());
        this.rendererCombo = this.setUpRendererChooser();
        this.updateDisplayChoices();
        jPanel3.add(this.displayResCombo);
        jPanel3.add(this.colorDepthCombo);
        jPanel3.add(this.displayFreqCombo);
        jPanel3.add(this.fullscreenBox);
        jPanel3.add(this.rendererCombo);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PropertiesDialog2.this.verifyAndSaveCurrentSelection()) {
                    PropertiesDialog2.this.dispose();
                }
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertiesDialog2.this.dispose();
                System.exit(0);
            }
        });
        jPanel4.add(jButton);
        jPanel4.add(jButton2);
        jPanel2.add((Component)this.icon, "North");
        jPanel2.add((Component)jPanel3, "South");
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel4, "South");
        this.getContentPane().add(jPanel);
        this.pack();
        this.center();
        this.showDialog();
    }

    private boolean verifyAndSaveCurrentSelection() {
        boolean bl;
        int n;
        String string = (String)this.displayResCombo.getSelectedItem();
        int n2 = Integer.parseInt(string.substring(0, string.indexOf(" x ")));
        string = string.substring(string.indexOf(" x ") + 3);
        int n3 = Integer.parseInt(string);
        String string2 = (String)this.colorDepthCombo.getSelectedItem();
        int n4 = Integer.parseInt(string2.substring(0, string2.indexOf(" ")));
        String string3 = (String)this.displayFreqCombo.getSelectedItem();
        int n5 = Integer.parseInt(string3.substring(0, string3.indexOf(" ")));
        boolean bl2 = this.fullscreenBox.isSelected();
        if (!bl2 && n4 > (n = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode().getBitDepth())) {
            PropertiesDialog2.showError(this, "Cannot choose a higher bit depth in windowed mode than your current desktop bit depth");
            return false;
        }
        String string4 = (String)this.rendererCombo.getSelectedItem();
        DisplaySystem displaySystem = DisplaySystem.getDisplaySystem(string4);
        boolean bl3 = bl = displaySystem != null ? displaySystem.isValidDisplayMode(n2, n3, n4, n5) : false;
        if (bl) {
            this.source.save(n2, n3, n4, n5, bl2, string4);
        } else {
            PropertiesDialog2.showError(this, "Your monitor claims to not support the display mode you've selected.\nThe combination of bit depth and refresh rate is not supported.");
        }
        return bl;
    }

    private JComboBox setUpResolutionChooser() {
        String[] stringArray = PropertiesDialog2.getResolutions(this.modes);
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setSelectedItem(this.source.getWidth() + " x " + this.source.getHeight());
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertiesDialog2.this.updateDisplayChoices();
            }
        });
        return jComboBox;
    }

    private JComboBox setUpRendererChooser() {
        String[] stringArray = DisplaySystem.getSystemProviderIdentifiers();
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setSelectedItem(this.source.getRenderer());
        return jComboBox;
    }

    private void updateDisplayChoices() {
        String string = (String)this.displayResCombo.getSelectedItem();
        String[] stringArray = PropertiesDialog2.getDepths(string, this.modes);
        this.colorDepthCombo.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.colorDepthCombo.setSelectedItem(this.source.getDepth() + " bpp");
        String[] stringArray2 = PropertiesDialog2.getFrequencies(string, this.modes);
        this.displayFreqCombo.setModel(new DefaultComboBoxModel<String>(stringArray2));
        this.displayFreqCombo.setSelectedItem(this.source.getFreq() + " Hz");
    }

    private static URL getURL(String string) {
        URL uRL = null;
        try {
            uRL = new URL("file:" + string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL;
    }

    private static void showError(Component component, String string) {
        JOptionPane.showMessageDialog(component, string, "Error", 0);
    }

    private static String[] getResolutions(DisplayMode[] displayModeArray) {
        ArrayList<String> arrayList = new ArrayList<String>(16);
        for (int i = 0; i < displayModeArray.length; ++i) {
            String string = displayModeArray[i].getWidth() + " x " + displayModeArray[i].getHeight();
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    private static String[] getDepths(String string, DisplayMode[] displayModeArray) {
        ArrayList<String> arrayList = new ArrayList<String>(4);
        for (int i = 0; i < displayModeArray.length; ++i) {
            if (displayModeArray[i].getBitDepth() < 16) continue;
            String string2 = displayModeArray[i].getWidth() + " x " + displayModeArray[i].getHeight();
            String string3 = String.valueOf(displayModeArray[i].getBitDepth()) + " bpp";
            if (!string2.equals(string) || arrayList.contains(string3)) continue;
            arrayList.add(string3);
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    private static String[] getFrequencies(String string, DisplayMode[] displayModeArray) {
        ArrayList<String> arrayList = new ArrayList<String>(4);
        for (int i = 0; i < displayModeArray.length; ++i) {
            String string2 = displayModeArray[i].getWidth() + " x " + displayModeArray[i].getHeight();
            String string3 = String.valueOf(displayModeArray[i].getRefreshRate()) + " Hz";
            if (!string2.equals(string) || arrayList.contains(string3)) continue;
            arrayList.add(string3);
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DisplayModeSorter
    implements Comparator<DisplayMode> {
        private DisplayModeSorter() {
        }

        @Override
        public int compare(DisplayMode displayMode, DisplayMode displayMode2) {
            if (displayMode.getWidth() != displayMode2.getWidth()) {
                return displayMode.getWidth() > displayMode2.getWidth() ? 1 : -1;
            }
            if (displayMode.getHeight() != displayMode2.getHeight()) {
                return displayMode.getHeight() > displayMode2.getHeight() ? 1 : -1;
            }
            if (displayMode.getBitDepth() != displayMode2.getBitDepth()) {
                return displayMode.getBitDepth() > displayMode2.getBitDepth() ? 1 : -1;
            }
            if (displayMode.getRefreshRate() != displayMode2.getRefreshRate()) {
                return displayMode.getRefreshRate() > displayMode2.getRefreshRate() ? 1 : -1;
            }
            return 0;
        }
    }
}

