/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.converters;

import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.scene.Controller;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.TriMesh;
import com.jme.system.JmeException;
import com.jme.system.dummy.DummyDisplaySystem;
import com.jme.util.BinaryFileReader;
import com.jme.util.export.Savable;
import com.jme.util.export.binary.BinaryExporter;
import com.jme.util.geom.BufferUtils;
import com.jmex.model.animation.KeyframeController;
import com.jmex.model.converters.FormatConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class Md2ToJme
extends FormatConverter {
    private static final float[][] norms = new float[][]{{-0.525731f, 0.0f, 0.850651f}, {-0.442863f, 0.238856f, 0.864188f}, {-0.295242f, 0.0f, 0.955423f}, {-0.309017f, 0.5f, 0.809017f}, {-0.16246f, 0.262866f, 0.951056f}, {0.0f, 0.0f, 1.0f}, {0.0f, 0.850651f, 0.525731f}, {-0.147621f, 0.716567f, 0.681718f}, {0.147621f, 0.716567f, 0.681718f}, {0.0f, 0.525731f, 0.850651f}, {0.309017f, 0.5f, 0.809017f}, {0.525731f, 0.0f, 0.850651f}, {0.295242f, 0.0f, 0.955423f}, {0.442863f, 0.238856f, 0.864188f}, {0.16246f, 0.262866f, 0.951056f}, {-0.681718f, 0.147621f, 0.716567f}, {-0.809017f, 0.309017f, 0.5f}, {-0.587785f, 0.425325f, 0.688191f}, {-0.850651f, 0.525731f, 0.0f}, {-0.864188f, 0.442863f, 0.238856f}, {-0.716567f, 0.681718f, 0.147621f}, {-0.688191f, 0.587785f, 0.425325f}, {-0.5f, 0.809017f, 0.309017f}, {-0.238856f, 0.864188f, 0.442863f}, {-0.425325f, 0.688191f, 0.587785f}, {-0.716567f, 0.681718f, -0.147621f}, {-0.5f, 0.809017f, -0.309017f}, {-0.525731f, 0.850651f, 0.0f}, {0.0f, 0.850651f, -0.525731f}, {-0.238856f, 0.864188f, -0.442863f}, {0.0f, 0.955423f, -0.295242f}, {-0.262866f, 0.951056f, -0.16246f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.955423f, 0.295242f}, {-0.262866f, 0.951056f, 0.16246f}, {0.238856f, 0.864188f, 0.442863f}, {0.262866f, 0.951056f, 0.16246f}, {0.5f, 0.809017f, 0.309017f}, {0.238856f, 0.864188f, -0.442863f}, {0.262866f, 0.951056f, -0.16246f}, {0.5f, 0.809017f, -0.309017f}, {0.850651f, 0.525731f, 0.0f}, {0.716567f, 0.681718f, 0.147621f}, {0.716567f, 0.681718f, -0.147621f}, {0.525731f, 0.850651f, 0.0f}, {0.425325f, 0.688191f, 0.587785f}, {0.864188f, 0.442863f, 0.238856f}, {0.688191f, 0.587785f, 0.425325f}, {0.809017f, 0.309017f, 0.5f}, {0.681718f, 0.147621f, 0.716567f}, {0.587785f, 0.425325f, 0.688191f}, {0.955423f, 0.295242f, 0.0f}, {1.0f, 0.0f, 0.0f}, {0.951056f, 0.16246f, 0.262866f}, {0.850651f, -0.525731f, 0.0f}, {0.955423f, -0.295242f, 0.0f}, {0.864188f, -0.442863f, 0.238856f}, {0.951056f, -0.16246f, 0.262866f}, {0.809017f, -0.309017f, 0.5f}, {0.681718f, -0.147621f, 0.716567f}, {0.850651f, 0.0f, 0.525731f}, {0.864188f, 0.442863f, -0.238856f}, {0.809017f, 0.309017f, -0.5f}, {0.951056f, 0.16246f, -0.262866f}, {0.525731f, 0.0f, -0.850651f}, {0.681718f, 0.147621f, -0.716567f}, {0.681718f, -0.147621f, -0.716567f}, {0.850651f, 0.0f, -0.525731f}, {0.809017f, -0.309017f, -0.5f}, {0.864188f, -0.442863f, -0.238856f}, {0.951056f, -0.16246f, -0.262866f}, {0.147621f, 0.716567f, -0.681718f}, {0.309017f, 0.5f, -0.809017f}, {0.425325f, 0.688191f, -0.587785f}, {0.442863f, 0.238856f, -0.864188f}, {0.587785f, 0.425325f, -0.688191f}, {0.688191f, 0.587785f, -0.425325f}, {-0.147621f, 0.716567f, -0.681718f}, {-0.309017f, 0.5f, -0.809017f}, {0.0f, 0.525731f, -0.850651f}, {-0.525731f, 0.0f, -0.850651f}, {-0.442863f, 0.238856f, -0.864188f}, {-0.295242f, 0.0f, -0.955423f}, {-0.16246f, 0.262866f, -0.951056f}, {0.0f, 0.0f, -1.0f}, {0.295242f, 0.0f, -0.955423f}, {0.16246f, 0.262866f, -0.951056f}, {-0.442863f, -0.238856f, -0.864188f}, {-0.309017f, -0.5f, -0.809017f}, {-0.16246f, -0.262866f, -0.951056f}, {0.0f, -0.850651f, -0.525731f}, {-0.147621f, -0.716567f, -0.681718f}, {0.147621f, -0.716567f, -0.681718f}, {0.0f, -0.525731f, -0.850651f}, {0.309017f, -0.5f, -0.809017f}, {0.442863f, -0.238856f, -0.864188f}, {0.16246f, -0.262866f, -0.951056f}, {0.238856f, -0.864188f, -0.442863f}, {0.5f, -0.809017f, -0.309017f}, {0.425325f, -0.688191f, -0.587785f}, {0.716567f, -0.681718f, -0.147621f}, {0.688191f, -0.587785f, -0.425325f}, {0.587785f, -0.425325f, -0.688191f}, {0.0f, -0.955423f, -0.295242f}, {0.0f, -1.0f, 0.0f}, {0.262866f, -0.951056f, -0.16246f}, {0.0f, -0.850651f, 0.525731f}, {0.0f, -0.955423f, 0.295242f}, {0.238856f, -0.864188f, 0.442863f}, {0.262866f, -0.951056f, 0.16246f}, {0.5f, -0.809017f, 0.309017f}, {0.716567f, -0.681718f, 0.147621f}, {0.525731f, -0.850651f, 0.0f}, {-0.238856f, -0.864188f, -0.442863f}, {-0.5f, -0.809017f, -0.309017f}, {-0.262866f, -0.951056f, -0.16246f}, {-0.850651f, -0.525731f, 0.0f}, {-0.716567f, -0.681718f, -0.147621f}, {-0.716567f, -0.681718f, 0.147621f}, {-0.525731f, -0.850651f, 0.0f}, {-0.5f, -0.809017f, 0.309017f}, {-0.238856f, -0.864188f, 0.442863f}, {-0.262866f, -0.951056f, 0.16246f}, {-0.864188f, -0.442863f, 0.238856f}, {-0.809017f, -0.309017f, 0.5f}, {-0.688191f, -0.587785f, 0.425325f}, {-0.681718f, -0.147621f, 0.716567f}, {-0.442863f, -0.238856f, 0.864188f}, {-0.587785f, -0.425325f, 0.688191f}, {-0.309017f, -0.5f, 0.809017f}, {-0.147621f, -0.716567f, 0.681718f}, {-0.425325f, -0.688191f, 0.587785f}, {-0.16246f, -0.262866f, 0.951056f}, {0.442863f, -0.238856f, 0.864188f}, {0.16246f, -0.262866f, 0.951056f}, {0.309017f, -0.5f, 0.809017f}, {0.147621f, -0.716567f, 0.681718f}, {0.0f, -0.525731f, 0.850651f}, {0.425325f, -0.688191f, 0.587785f}, {0.587785f, -0.425325f, 0.688191f}, {0.688191f, -0.587785f, 0.425325f}, {-0.955423f, 0.295242f, 0.0f}, {-0.951056f, 0.16246f, 0.262866f}, {-1.0f, 0.0f, 0.0f}, {-0.850651f, 0.0f, 0.525731f}, {-0.955423f, -0.295242f, 0.0f}, {-0.951056f, -0.16246f, 0.262866f}, {-0.864188f, 0.442863f, -0.238856f}, {-0.951056f, 0.16246f, -0.262866f}, {-0.809017f, 0.309017f, -0.5f}, {-0.864188f, -0.442863f, -0.238856f}, {-0.951056f, -0.16246f, -0.262866f}, {-0.809017f, -0.309017f, -0.5f}, {-0.681718f, 0.147621f, -0.716567f}, {-0.681718f, -0.147621f, -0.716567f}, {-0.850651f, 0.0f, -0.525731f}, {-0.688191f, 0.587785f, -0.425325f}, {-0.587785f, 0.425325f, -0.688191f}, {-0.425325f, 0.688191f, -0.587785f}, {-0.425325f, -0.688191f, -0.587785f}, {-0.587785f, -0.425325f, -0.688191f}, {-0.688191f, -0.587785f, -0.425325f}};

    public static void main(String[] stringArray) {
        new DummyDisplaySystem();
        new Md2ToJme().attemptFileConvert(stringArray);
    }

    public void convert(InputStream inputStream, OutputStream outputStream) throws IOException {
        if (inputStream == null) {
            throw new NullPointerException("Unable to load null streams");
        }
        Md2ConverterCopy md2ConverterCopy = new Md2ConverterCopy(inputStream);
        Node node = new Node(md2ConverterCopy.mesh.getName());
        node.attachChild((Spatial)md2ConverterCopy.mesh);
        BinaryExporter.getInstance().save((Savable)node, outputStream);
    }

    public static KeyframeController findController(Node node) {
        if (node.getQuantity() == 0 || node.getChild(0).getControllers().size() == 0 || !(node.getChild(0).getController(0) instanceof KeyframeController)) {
            return null;
        }
        return (KeyframeController)node.getChild(0).getController(0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Md2ConverterCopy {
        private static final long serialVersionUID = 1L;
        private BinaryFileReader bis = null;
        private Header header;
        private Vector2f[] texCoords;
        private Md2Face[] triangles;
        private Md2Frame[] frames;
        private TriMesh[] triMesh;
        private KeyframeController controller;
        public TriMesh mesh;

        public Md2ConverterCopy(InputStream inputStream) {
            if (null == inputStream) {
                throw new JmeException("Null data. Cannot load.");
            }
            this.mesh = new TriMesh("MD2 mesh" + new Random().nextInt());
            this.bis = new BinaryFileReader(inputStream);
            this.header = new Header();
            if (this.header.version != 8) {
                throw new JmeException("Invalid file format (Version not 8)!");
            }
            this.parseMesh();
            this.convertDataStructures();
            this.triangles = null;
            this.texCoords = null;
            this.frames = null;
        }

        public Controller getAnimationController() {
            return this.controller;
        }

        private void parseMesh() {
            int n;
            String[] stringArray = new String[this.header.numSkins];
            this.texCoords = new Vector2f[this.header.numTexCoords];
            this.triangles = new Md2Face[this.header.numTriangles];
            this.frames = new Md2Frame[this.header.numFrames];
            this.bis.setOffset(this.header.offsetSkins);
            for (n = 0; n < this.header.numSkins; ++n) {
                stringArray[n] = this.bis.readString(64);
            }
            this.bis.setOffset(this.header.offsetTexCoords);
            for (n = 0; n < this.header.numTexCoords; ++n) {
                this.texCoords[n] = new Vector2f();
                this.texCoords[n].x = this.bis.readShort();
                this.texCoords[n].y = this.bis.readShort();
            }
            this.bis.setOffset(this.header.offsetTriangles);
            for (n = 0; n < this.header.numTriangles; ++n) {
                this.triangles[n] = new Md2Face();
            }
            this.bis.setOffset(this.header.offsetFrames);
            for (n = 0; n < this.header.numFrames; ++n) {
                VectorKeyframe vectorKeyframe = new VectorKeyframe();
                this.frames[n] = new Md2Frame();
                this.frames[n].vertices = new Triangle[this.header.numVertices];
                Vector3f[] vector3fArray = new Vector3f[this.header.numVertices];
                int[] nArray = new int[this.header.numVertices];
                for (int i = 0; i < this.header.numVertices; ++i) {
                    vector3fArray[i] = new Vector3f((float)this.bis.readByte(), (float)this.bis.readByte(), (float)this.bis.readByte());
                    nArray[i] = this.bis.readByte();
                }
                this.frames[n].name = vectorKeyframe.name;
                Triangle[] triangleArray = this.frames[n].vertices;
                for (int i = 0; i < this.header.numVertices; ++i) {
                    triangleArray[i] = new Triangle();
                    triangleArray[i].vertex.x = vector3fArray[i].x * ((VectorKeyframe)vectorKeyframe).scale.x + ((VectorKeyframe)vectorKeyframe).translate.x;
                    triangleArray[i].vertex.z = -1.0f * (vector3fArray[i].y * ((VectorKeyframe)vectorKeyframe).scale.y + ((VectorKeyframe)vectorKeyframe).translate.y);
                    triangleArray[i].vertex.y = vector3fArray[i].z * ((VectorKeyframe)vectorKeyframe).scale.z + ((VectorKeyframe)vectorKeyframe).translate.z;
                    triangleArray[i].normal.x = norms[nArray[i]][0];
                    triangleArray[i].normal.y = norms[nArray[i]][2];
                    triangleArray[i].normal.z = -norms[nArray[i]][1];
                }
            }
            this.bis.setOffset(this.header.offsetGlCommands);
        }

        private void convertDataStructures() {
            this.triMesh = new TriMesh[this.header.numFrames];
            ArrayList<VectorTex> arrayList = new ArrayList<VectorTex>();
            this.controller = new KeyframeController();
            for (int i = 0; i < this.header.numFrames; ++i) {
                Object[] objectArray;
                int n;
                int n2 = this.header.numVertices;
                int n3 = this.header.numTexCoords;
                this.triMesh[i] = i != 0 ? new TriMesh() : this.mesh;
                Vector3f[] vector3fArray = new Vector3f[n2];
                Vector3f[] vector3fArray2 = new Vector3f[n2];
                Vector2f[] vector2fArray = new Vector2f[n3];
                for (n = 0; n < n2; ++n) {
                    if (i != 0) {
                        vector3fArray[n] = this.frames[i].vertices[n].vertex;
                        vector3fArray2[n] = this.frames[i].vertices[n].normal;
                        continue;
                    }
                    vector3fArray[n] = new Vector3f(this.frames[i].vertices[n].vertex);
                    vector3fArray2[n] = new Vector3f(this.frames[i].vertices[n].normal);
                }
                if (i == 0) {
                    int n4;
                    for (n = 0; n < n3; ++n) {
                        vector2fArray[n] = new Vector2f();
                        vector2fArray[n].x = this.texCoords[n].x / (float)this.header.skinWidth;
                        vector2fArray[n].y = 1.0f - this.texCoords[n].y / (float)this.header.skinHeight;
                    }
                    if (n3 != 0) {
                        for (n = 0; n < this.header.numTriangles; ++n) {
                            for (n4 = 0; n4 < 3; ++n4) {
                                VectorTex vectorTex = new VectorTex(this.triangles[n].vertexIndices[n4], this.triangles[n].textureIndices[n4]);
                                if (arrayList.contains(vectorTex)) continue;
                                arrayList.add(vectorTex);
                            }
                        }
                    }
                    ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                    for (n4 = 0; n4 < this.header.numTriangles; ++n4) {
                        block6: for (int j = 0; j < 3; ++j) {
                            for (int k = 0; k < arrayList.size(); ++k) {
                                VectorTex vectorTex = (VectorTex)arrayList.get(k);
                                if (!vectorTex.matches(this.triangles[n4], j)) continue;
                                arrayList2.add(k);
                                continue block6;
                            }
                        }
                    }
                    objectArray = new int[arrayList2.size()];
                    for (int j = 0; j < objectArray.length; ++j) {
                        objectArray[j] = (Vector3f)((Integer)arrayList2.get(j));
                    }
                    this.triMesh[0].setIndexBuffer(0, BufferUtils.createIntBuffer((int[])objectArray));
                    this.triMesh[0].setTextureBuffer(0, BufferUtils.createFloatBuffer((Vector2f[])this.extractTexCoords(arrayList, vector2fArray, arrayList2.size())));
                    this.controller.setMorphingMesh(this.triMesh[0]);
                }
                Vector3f[] vector3fArray3 = this.extractVertices(arrayList, vector3fArray);
                this.triMesh[i].setVertexBuffer(0, BufferUtils.createFloatBuffer((Vector3f[])vector3fArray3));
                objectArray = this.extractNormals(arrayList, vector3fArray2);
                this.triMesh[i].setNormalBuffer(0, BufferUtils.createFloatBuffer((Vector3f[])objectArray));
                this.controller.setKeyframe(i, this.triMesh[i]);
            }
            this.mesh.addController((Controller)this.controller);
        }

        private Vector3f[] extractVertices(List<VectorTex> list, Vector3f[] vector3fArray) {
            ArrayList<Vector3f> arrayList = new ArrayList<Vector3f>();
            for (int i = 0; i < list.size(); ++i) {
                VectorTex vectorTex = list.get(i);
                Vector3f vector3f = vector3fArray[vectorTex.v];
                arrayList.add(vector3f);
            }
            return arrayList.toArray(new Vector3f[arrayList.size()]);
        }

        private Vector3f[] extractNormals(List<VectorTex> list, Vector3f[] vector3fArray) {
            ArrayList<Vector3f> arrayList = new ArrayList<Vector3f>();
            for (int i = 0; i < list.size(); ++i) {
                VectorTex vectorTex = list.get(i);
                Vector3f vector3f = vector3fArray[vectorTex.v];
                arrayList.add(vector3f);
            }
            return arrayList.toArray(new Vector3f[arrayList.size()]);
        }

        private Vector2f[] extractTexCoords(List<VectorTex> list, Vector2f[] vector2fArray, int n) {
            Vector2f[] vector2fArray2 = new Vector2f[n];
            int n2 = 0;
            for (int i = 0; i < list.size(); ++i) {
                VectorTex vectorTex = list.get(i);
                Vector2f vector2f = vector2fArray[vectorTex.t];
                vector2fArray2[n2++] = vector2f;
            }
            return vector2fArray2;
        }

        private class Md2Frame {
            String name;
            Triangle[] vertices;

            Md2Frame() {
            }
        }

        private class VectorKeyframe {
            private Vector3f scale = new Vector3f();
            private Vector3f translate = new Vector3f();
            private String name;

            VectorKeyframe() {
                this.scale.x = Md2ConverterCopy.this.bis.readFloat();
                this.scale.y = Md2ConverterCopy.this.bis.readFloat();
                this.scale.z = Md2ConverterCopy.this.bis.readFloat();
                this.translate.x = Md2ConverterCopy.this.bis.readFloat();
                this.translate.y = Md2ConverterCopy.this.bis.readFloat();
                this.translate.z = Md2ConverterCopy.this.bis.readFloat();
                this.name = Md2ConverterCopy.this.bis.readString(16);
            }
        }

        private class Md2Face {
            int[] vertexIndices = new int[3];
            int[] textureIndices = new int[3];

            Md2Face() {
                this.vertexIndices = new int[]{Md2ConverterCopy.this.bis.readShort(), Md2ConverterCopy.this.bis.readShort(), Md2ConverterCopy.this.bis.readShort()};
                this.textureIndices = new int[]{Md2ConverterCopy.this.bis.readShort(), Md2ConverterCopy.this.bis.readShort(), Md2ConverterCopy.this.bis.readShort()};
            }
        }

        private class Triangle {
            Vector3f vertex = new Vector3f();
            Vector3f normal = new Vector3f();

            private Triangle() {
            }
        }

        private class Header {
            int magic;
            int version;
            int skinWidth;
            int skinHeight;
            int frameSize;
            int numSkins;
            int numVertices;
            int numTexCoords;
            int numTriangles;
            int numGlCommands;
            int numFrames;
            int offsetSkins;
            int offsetTexCoords;
            int offsetTriangles;
            int offsetFrames;
            int offsetGlCommands;
            int offsetEnd;

            Header() {
                this.magic = Md2ConverterCopy.this.bis.readInt();
                this.version = Md2ConverterCopy.this.bis.readInt();
                this.skinWidth = Md2ConverterCopy.this.bis.readInt();
                this.skinHeight = Md2ConverterCopy.this.bis.readInt();
                this.frameSize = Md2ConverterCopy.this.bis.readInt();
                this.numSkins = Md2ConverterCopy.this.bis.readInt();
                this.numVertices = Md2ConverterCopy.this.bis.readInt();
                this.numTexCoords = Md2ConverterCopy.this.bis.readInt();
                this.numTriangles = Md2ConverterCopy.this.bis.readInt();
                this.numGlCommands = Md2ConverterCopy.this.bis.readInt();
                this.numFrames = Md2ConverterCopy.this.bis.readInt();
                this.offsetSkins = Md2ConverterCopy.this.bis.readInt();
                this.offsetTexCoords = Md2ConverterCopy.this.bis.readInt();
                this.offsetTriangles = Md2ConverterCopy.this.bis.readInt();
                this.offsetFrames = Md2ConverterCopy.this.bis.readInt();
                this.offsetGlCommands = Md2ConverterCopy.this.bis.readInt();
                this.offsetEnd = Md2ConverterCopy.this.bis.readInt();
            }
        }

        private static class VectorTex {
            int v;
            int t;

            private VectorTex(int n, int n2) {
                this.v = n;
                this.t = n2;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                VectorTex vectorTex = (VectorTex)object;
                if (this.t != vectorTex.t) {
                    return false;
                }
                return this.v == vectorTex.v;
            }

            public int hashCode() {
                int n = this.v;
                n = 31 * n + this.t;
                return n;
            }

            public boolean matches(Md2Face md2Face, int n) {
                return md2Face.vertexIndices[n] == this.v && md2Face.textureIndices[n] == this.t;
            }
        }
    }
}

