/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.converters.maxutils;

import com.jme.renderer.ColorRGBA;
import com.jmex.model.converters.maxutils.ChunkHeader;
import com.jmex.model.converters.maxutils.ChunkerClass;
import java.io.DataInput;
import java.io.IOException;
import java.util.logging.Logger;

class FogChunk
extends ChunkerClass {
    private static final Logger logger = Logger.getLogger(FogChunk.class.getName());
    float nearPlane;
    float nearDensity;
    float farPlane;
    float farDensity;
    private boolean useBackGround;
    private ColorRGBA background;

    public FogChunk(DataInput dataInput, ChunkHeader chunkHeader) throws IOException {
        super(dataInput, chunkHeader);
    }

    protected void initializeVariables() throws IOException {
        this.nearPlane = this.myIn.readFloat();
        this.nearDensity = this.myIn.readFloat();
        this.farPlane = this.myIn.readFloat();
        this.farDensity = this.myIn.readFloat();
        this.decrHeaderLen(16);
        if (DEBUG || DEBUG_LIGHT) {
            logger.info("Near plane:" + this.nearPlane + " Near Density:" + this.nearDensity + " Far Plane:" + this.farPlane + " Far Density:" + this.farDensity);
        }
    }

    protected boolean processChildChunk(ChunkHeader chunkHeader) throws IOException {
        switch (chunkHeader.type) {
            case 16: {
                this.background = new ColorRGBA(this.myIn.readFloat(), this.myIn.readFloat(), this.myIn.readFloat(), 1.0f);
                if (DEBUG) {
                    logger.info("Background Color:" + this.background);
                }
                return true;
            }
            case 8720: {
                this.useBackGround = true;
                if (DEBUG) {
                    logger.info("use background true");
                }
                return true;
            }
        }
        return false;
    }
}

