/*
 * Decompiled with CFR 0.152.
 */
package com.jme.app;

import com.jme.app.AbstractGame;
import com.jme.renderer.Renderer;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BaseHeadlessApp
extends AbstractGame {
    private static final Logger logger = Logger.getLogger(BaseHeadlessApp.class.getName());

    public final void start() {
        logger.info("Application started.");
        try {
            this.getAttributes();
            this.initSystem();
            this.assertDisplayCreated();
            this.initGame();
            Renderer renderer = this.display.getRenderer();
            while (!this.finished && !this.display.isClosing()) {
                this.update(-1.0f);
                this.render(-1.0f);
                renderer.displayBackBuffer();
            }
        }
        catch (Throwable throwable) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "start()", "Exception in game loop", throwable);
            throwable.printStackTrace();
        }
        this.cleanup();
        logger.info("Application ending.");
        if (this.display != null) {
            this.display.reset();
        }
        this.quit();
    }

    protected void quit() {
        if (this.display != null) {
            this.display.close();
        }
        System.exit(0);
    }

    protected abstract void update(float var1);

    protected abstract void render(float var1);

    protected abstract void initSystem();

    protected abstract void initGame();

    protected abstract void reinit();

    protected abstract void cleanup();
}

