/*
 * Decompiled with CFR 0.152.
 */
package com.jme.bounding;

import com.jme.bounding.CollisionTree;
import com.jme.bounding.CollisionTreeController;
import com.jme.bounding.UsageTreeController;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.TriMesh;
import com.jme.scene.batch.SharedBatch;
import com.jme.scene.batch.TriangleBatch;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public class CollisionTreeManager {
    public static final int DEFAULT_MAX_ELEMENTS = 25;
    public static final int DEFAULT_MAX_TRIS_PER_LEAF = 16;
    private static CollisionTreeManager instance;
    private LinkedHashMap<TriangleBatch, CollisionTree> cache = new LinkedHashMap(1);
    private ArrayList<TriangleBatch> protectedList;
    private boolean generateTrees = true;
    private boolean doSort;
    private int treeType = 1;
    private int maxTrisPerLeaf = 16;
    private int maxElements = 25;
    private CollisionTreeController treeRemover;

    private CollisionTreeManager() {
    }

    public static CollisionTreeManager getInstance() {
        if (instance == null) {
            instance = new CollisionTreeManager();
            instance.setCollisionTreeController(new UsageTreeController());
        }
        return instance;
    }

    public void setCollisionTreeController(CollisionTreeController collisionTreeController) {
        this.treeRemover = collisionTreeController;
    }

    public CollisionTree getCollisionTree(TriangleBatch triangleBatch) {
        CollisionTree collisionTree = null;
        if (triangleBatch instanceof SharedBatch) {
            collisionTree = this.cache.get(((SharedBatch)triangleBatch).getTarget());
            if (collisionTree != null) {
                collisionTree.setParent((TriMesh)triangleBatch.getParentGeom());
            }
        } else {
            collisionTree = this.cache.get(triangleBatch);
        }
        if (collisionTree == null) {
            if (this.generateTrees) {
                return this.generateCollisionTree(this.treeType, triangleBatch, false);
            }
            return null;
        }
        this.cache.remove(triangleBatch);
        this.cache.put(triangleBatch, collisionTree);
        return collisionTree;
    }

    public void generateCollisionTree(int n, Spatial spatial, boolean bl) {
        block3: {
            block2: {
                if (!(spatial instanceof Node)) break block2;
                Node node = (Node)spatial;
                for (int i = node.getQuantity() - 1; i >= 0; --i) {
                    this.generateCollisionTree(n, node.getChild(i), bl);
                }
                break block3;
            }
            if (!(spatial instanceof TriMesh)) break block3;
            TriMesh triMesh = (TriMesh)spatial;
            for (int i = 0; i < triMesh.getBatchCount(); ++i) {
                this.generateCollisionTree(n, triMesh.getBatch(i), bl);
            }
        }
    }

    public CollisionTree generateCollisionTree(int n, TriangleBatch triangleBatch, boolean bl) {
        if (triangleBatch == null) {
            return null;
        }
        CollisionTree collisionTree = new CollisionTree(n);
        return this.generateCollisionTree(collisionTree, triangleBatch, bl);
    }

    public CollisionTree generateCollisionTree(CollisionTree collisionTree, TriangleBatch triangleBatch, boolean bl) {
        if (collisionTree != null) {
            if (triangleBatch instanceof SharedBatch) {
                if (!this.cache.containsKey(((SharedBatch)triangleBatch).getTarget())) {
                    collisionTree.construct(((SharedBatch)triangleBatch).getTarget(), (TriMesh)((SharedBatch)triangleBatch).getTarget().getParentGeom(), this.doSort);
                    this.cache.put(((SharedBatch)triangleBatch).getTarget(), collisionTree);
                    if (bl) {
                        if (this.protectedList == null) {
                            this.protectedList = new ArrayList(1);
                        }
                        this.protectedList.add(((SharedBatch)triangleBatch).getTarget());
                    }
                }
                collisionTree.setParent((TriMesh)triangleBatch.getParentGeom());
            } else {
                collisionTree.construct(triangleBatch, (TriMesh)triangleBatch.getParentGeom(), this.doSort);
                this.cache.put(triangleBatch, collisionTree);
                if (bl) {
                    if (this.protectedList == null) {
                        this.protectedList = new ArrayList(1);
                    }
                    this.protectedList.add(triangleBatch);
                }
            }
            if (this.cache.size() > this.maxElements && this.treeRemover != null) {
                this.treeRemover.clean(this.cache, this.protectedList, this.maxElements);
            }
        }
        return collisionTree;
    }

    public void removeCollisionTree(TriangleBatch triangleBatch) {
        this.cache.remove(triangleBatch);
    }

    public void removeCollisionTree(Spatial spatial) {
        block3: {
            block2: {
                if (!(spatial instanceof Node)) break block2;
                Node node = (Node)spatial;
                for (int i = node.getQuantity() - 1; i >= 0; --i) {
                    this.removeCollisionTree(node.getChild(i));
                }
                break block3;
            }
            if (!(spatial instanceof TriMesh)) break block3;
            TriMesh triMesh = (TriMesh)spatial;
            for (int i = triMesh.getBatchCount() - 1; i >= 0; --i) {
                this.removeCollisionTree(triMesh.getBatch(i));
            }
        }
    }

    public void updateCollisionTree(TriangleBatch triangleBatch) {
        CollisionTree collisionTree = this.cache.get(triangleBatch);
        if (collisionTree != null) {
            this.generateCollisionTree(collisionTree, triangleBatch, this.protectedList != null && this.protectedList.contains(triangleBatch));
        }
    }

    public void updateCollisionTree(Spatial spatial) {
        block3: {
            block2: {
                if (!(spatial instanceof Node)) break block2;
                Node node = (Node)spatial;
                for (int i = node.getQuantity() - 1; i >= 0; --i) {
                    this.updateCollisionTree(node.getChild(i));
                }
                break block3;
            }
            if (!(spatial instanceof TriMesh)) break block3;
            TriMesh triMesh = (TriMesh)spatial;
            for (int i = 0; i < triMesh.getBatchCount(); ++i) {
                this.updateCollisionTree(triMesh.getBatch(i));
            }
        }
    }

    public boolean isDoSort() {
        return this.doSort;
    }

    public void setDoSort(boolean bl) {
        this.doSort = bl;
    }

    public boolean isGenerateTrees() {
        return this.generateTrees;
    }

    public void setGenerateTrees(boolean bl) {
        this.generateTrees = bl;
    }

    public int getTreeType() {
        return this.treeType;
    }

    public void setTreeType(int n) {
        this.treeType = n;
    }

    public int getMaxTrisPerLeaf() {
        return this.maxTrisPerLeaf;
    }

    public void setMaxTrisPerLeaf(int n) {
        this.maxTrisPerLeaf = n;
    }
}

