/*
 * Decompiled with CFR 0.152.
 */
package com.jme.input.controls;

import com.jme.input.controls.GameControl;
import com.jme.system.GameSettings;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameControlManager
implements Serializable {
    private static final long serialVersionUID = -59765658953779536L;
    private Map<String, GameControl> controls = new LinkedHashMap<String, GameControl>();
    private boolean enabled = true;

    public void createControls(String ... stringArray) {
        for (String string : stringArray) {
            this.addControl(string);
        }
    }

    public GameControl addControl(String string) {
        GameControl gameControl = new GameControl(string, this);
        this.controls.put(string, gameControl);
        return gameControl;
    }

    public GameControl getControl(String string) {
        return this.controls.get(string);
    }

    public GameControl removeControl(String string) {
        return this.controls.remove(string);
    }

    public Set<String> getControlNames() {
        return this.controls.keySet();
    }

    public Collection<GameControl> getControls() {
        return this.controls.values();
    }

    public void clearBindings() {
        for (GameControl gameControl : this.controls.values()) {
            gameControl.clearBindings();
        }
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public static final void save(GameControlManager gameControlManager, GameSettings gameSettings) {
        gameSettings.setObject("GameControls", gameControlManager);
    }

    public static final GameControlManager load(GameSettings gameSettings) {
        return (GameControlManager)gameSettings.getObject("GameControls", null);
    }
}

