/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.state.lwjgl;

import com.jme.renderer.RenderContext;
import com.jme.scene.state.VertexProgramState;
import com.jme.scene.state.lwjgl.records.StateRecord;
import com.jme.scene.state.lwjgl.records.VertexProgramStateRecord;
import com.jme.system.DisplaySystem;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBProgram;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

public class LWJGLVertexProgramState
extends VertexProgramState {
    private static final Logger logger = Logger.getLogger(LWJGLVertexProgramState.class.getName());
    private static final long serialVersionUID = 1L;
    private int programID = -1;

    public boolean isSupported() {
        return GLContext.getCapabilities().GL_ARB_vertex_program;
    }

    public void load(URL uRL) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(16384);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
            byte[] byArray = new byte[1024];
            int n = -1;
            byte[] byArray2 = null;
            while ((n = ((InputStream)bufferedInputStream).read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byArray2 = byteArrayOutputStream.toByteArray();
            ((InputStream)bufferedInputStream).close();
            byteArrayOutputStream.close();
            this.program = BufferUtils.createByteBuffer((int)byArray2.length);
            this.program.put(byArray2);
            this.program.rewind();
            this.programID = -1;
            this.setNeedsRefresh(true);
        }
        catch (Exception exception) {
            logger.severe("Could not load fragment program: " + exception);
            logger.logp(Level.SEVERE, this.getClass().getName(), "load(URL)", "Exception", exception);
        }
    }

    public void load(String string) {
        try {
            byte[] byArray = string.getBytes();
            this.program = BufferUtils.createByteBuffer((int)byArray.length);
            this.program.put(byArray);
            this.program.rewind();
            this.programID = -1;
            this.setNeedsRefresh(true);
        }
        catch (Exception exception) {
            logger.severe("Could not load fragment program: " + exception);
            logger.logp(Level.SEVERE, this.getClass().getName(), "load(URL)", "Exception", exception);
        }
    }

    private void checkProgramError() {
        if (GL11.glGetError() == 1282) {
            IntBuffer intBuffer = BufferUtils.createIntBuffer((int)16);
            GL11.glGetInteger((int)34379, (IntBuffer)intBuffer);
            logger.severe("Error " + GL11.glGetString((int)34932) + " in vertex program on line " + intBuffer.get(0));
        }
    }

    public String getProgram() {
        if (this.program == null) {
            return null;
        }
        this.program.rewind();
        byte[] byArray = new byte[this.program.remaining()];
        this.program.get(byArray);
        return new String(byArray);
    }

    private void create() {
        if (this.program == null) {
            logger.severe("Attempted to apply unloaded vertex program state.");
            return;
        }
        IntBuffer intBuffer = BufferUtils.createIntBuffer((int)1);
        ARBProgram.glGenProgramsARB((IntBuffer)intBuffer);
        ARBProgram.glBindProgramARB((int)34336, (int)intBuffer.get(0));
        ARBProgram.glProgramStringARB((int)34336, (int)34933, (ByteBuffer)this.program);
        this.checkProgramError();
        this.programID = intBuffer.get(0);
    }

    public void apply() {
        if (this.isSupported()) {
            RenderContext renderContext = DisplaySystem.getDisplaySystem().getCurrentContext();
            VertexProgramStateRecord vertexProgramStateRecord = (VertexProgramStateRecord)renderContext.getStateRecord(10);
            renderContext.currentStates[10] = this;
            if (!vertexProgramStateRecord.isValid() || vertexProgramStateRecord.getReference() != this) {
                vertexProgramStateRecord.setReference(this);
                if (this.isEnabled()) {
                    int n;
                    if (this.programID == -1) {
                        if (this.program != null) {
                            this.create();
                        } else {
                            return;
                        }
                    }
                    GL11.glEnable((int)34336);
                    ARBProgram.glBindProgramARB((int)34336, (int)this.programID);
                    for (n = 0; n < envparameters.length; ++n) {
                        if (envparameters[n] == null) continue;
                        ARBProgram.glProgramEnvParameter4fARB((int)34336, (int)n, (float)envparameters[n][0], (float)envparameters[n][1], (float)envparameters[n][2], (float)envparameters[n][3]);
                    }
                    if (this.usingParameters) {
                        for (n = 0; n < this.parameters.length; ++n) {
                            if (this.parameters[n] == null) continue;
                            ARBProgram.glProgramLocalParameter4fARB((int)34336, (int)n, (float)this.parameters[n][0], (float)this.parameters[n][1], (float)this.parameters[n][2], (float)this.parameters[n][3]);
                        }
                    }
                } else {
                    GL11.glDisable((int)34336);
                }
            }
            if (!vertexProgramStateRecord.isValid()) {
                vertexProgramStateRecord.validate();
            }
        }
    }

    public StateRecord createStateRecord() {
        return new VertexProgramStateRecord();
    }
}

