/*
 * Decompiled with CFR 0.152.
 */
package com.jme.system.lwjgl;

import com.jme.system.DisplaySystem;
import com.jme.system.JmeException;
import com.jme.system.PropertiesIO;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;

public final class LWJGLPropertiesDialog
extends JDialog {
    private static final Logger logger = Logger.getLogger(LWJGLPropertiesDialog.class.getName());
    private static final long serialVersionUID = 1L;
    private final PropertiesIO source;
    private URL imageFile = null;
    private DisplayMode[] modes = null;
    private JCheckBox fullscreenBox = null;
    private JComboBox displayResCombo = null;
    private JComboBox colorDepthCombo = null;
    private JComboBox displayFreqCombo = null;
    private JComboBox rendererCombo = null;
    private JLabel icon = null;
    private boolean cancelled = false;

    public LWJGLPropertiesDialog(PropertiesIO propertiesIO, String string) {
        this(propertiesIO, LWJGLPropertiesDialog.getURL(string));
    }

    public LWJGLPropertiesDialog(PropertiesIO propertiesIO, URL uRL) {
        if (null == propertiesIO) {
            throw new JmeException("PropertyIO source cannot be null");
        }
        this.source = propertiesIO;
        this.imageFile = uRL;
        try {
            this.modes = Display.getAvailableDisplayModes();
        }
        catch (LWJGLException lWJGLException) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "LWJGLPropertiesDialog(PropertiesIO, URL)", "Exception", lWJGLException);
        }
        Arrays.sort(this.modes, new DisplayModeSorter());
        this.createUI();
    }

    public void setImage(String string) {
        try {
            URL uRL = new URL("file:" + string);
            this.setImage(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void setImage(URL uRL) {
        this.icon.setIcon(new ImageIcon(uRL));
        this.pack();
        this.center();
    }

    private void showDialog() {
        this.setVisible(true);
        this.toFront();
    }

    private void center() {
        int n = (Toolkit.getDefaultToolkit().getScreenSize().width - this.getWidth()) / 2;
        int n2 = (Toolkit.getDefaultToolkit().getScreenSize().height - this.getHeight()) / 2;
        this.setLocation(n, n2);
    }

    private void createUI() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            logger.warning("Could not set native look and feel.");
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                LWJGLPropertiesDialog.this.cancelled = true;
                LWJGLPropertiesDialog.this.dispose();
            }
        });
        this.setTitle("Select Display Settings");
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JButton jButton = new JButton("Ok");
        JButton jButton2 = new JButton("Cancel");
        this.icon = new JLabel(this.imageFile != null ? new ImageIcon(this.imageFile) : null);
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new BorderLayout());
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 && LWJGLPropertiesDialog.this.verifyAndSaveCurrentSelection()) {
                    LWJGLPropertiesDialog.this.dispose();
                }
            }
        };
        this.displayResCombo = this.setUpResolutionChooser();
        this.displayResCombo.addKeyListener(keyAdapter);
        this.colorDepthCombo = new JComboBox();
        this.colorDepthCombo.addKeyListener(keyAdapter);
        this.displayFreqCombo = new JComboBox();
        this.displayFreqCombo.addKeyListener(keyAdapter);
        this.fullscreenBox = new JCheckBox("Fullscreen?");
        this.fullscreenBox.setSelected(this.source.getFullscreen());
        this.rendererCombo = this.setUpRendererChooser();
        this.rendererCombo.addKeyListener(keyAdapter);
        this.updateDisplayChoices();
        jPanel3.add(this.displayResCombo);
        jPanel3.add(this.colorDepthCombo);
        jPanel3.add(this.displayFreqCombo);
        jPanel3.add(this.fullscreenBox);
        jPanel3.add(this.rendererCombo);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (LWJGLPropertiesDialog.this.verifyAndSaveCurrentSelection()) {
                    LWJGLPropertiesDialog.this.dispose();
                }
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LWJGLPropertiesDialog.this.cancelled = true;
                LWJGLPropertiesDialog.this.dispose();
            }
        });
        jPanel4.add(jButton);
        jPanel4.add(jButton2);
        if (this.icon != null) {
            jPanel2.add((Component)this.icon, "North");
        }
        jPanel2.add((Component)jPanel3, "South");
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel4, "South");
        this.getContentPane().add(jPanel);
        this.pack();
        this.center();
        this.showDialog();
    }

    private boolean verifyAndSaveCurrentSelection() {
        boolean bl;
        String string = (String)this.displayResCombo.getSelectedItem();
        int n = Integer.parseInt(string.substring(0, string.indexOf(" x ")));
        string = string.substring(string.indexOf(" x ") + 3);
        int n2 = Integer.parseInt(string);
        String string2 = (String)this.colorDepthCombo.getSelectedItem();
        int n3 = Integer.parseInt(string2.substring(0, string2.indexOf(" ")));
        String string3 = (String)this.displayFreqCombo.getSelectedItem();
        int n4 = Integer.parseInt(string3.substring(0, string3.indexOf(" ")));
        boolean bl2 = this.fullscreenBox.isSelected();
        String string4 = (String)this.rendererCombo.getSelectedItem();
        DisplaySystem displaySystem = DisplaySystem.getDisplaySystem(string4);
        boolean bl3 = bl = displaySystem != null ? displaySystem.isValidDisplayMode(n, n2, n3, n4) : false;
        if (bl) {
            this.source.save(n, n2, n3, n4, bl2, string4);
        } else {
            LWJGLPropertiesDialog.showError(this, "Your monitor claims to not support the display mode you've selected.\nThe combination of bit depth and refresh rate is not supported.");
        }
        return bl;
    }

    private JComboBox setUpResolutionChooser() {
        String[] stringArray = LWJGLPropertiesDialog.getResolutions(this.modes);
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setSelectedItem(this.source.getWidth() + " x " + this.source.getHeight());
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LWJGLPropertiesDialog.this.updateDisplayChoices();
            }
        });
        return jComboBox;
    }

    private JComboBox setUpRendererChooser() {
        String[] stringArray = DisplaySystem.getSystemProviderIdentifiers();
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setSelectedItem(this.source.getRenderer());
        return jComboBox;
    }

    private void updateDisplayChoices() {
        String string = (String)this.displayResCombo.getSelectedItem();
        String[] stringArray = LWJGLPropertiesDialog.getDepths(string, this.modes);
        this.colorDepthCombo.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.colorDepthCombo.setSelectedItem(this.source.getDepth() + " bpp");
        String[] stringArray2 = LWJGLPropertiesDialog.getFrequencies(string, this.modes);
        this.displayFreqCombo.setModel(new DefaultComboBoxModel<String>(stringArray2));
        this.displayFreqCombo.setSelectedItem(this.source.getFreq() + " Hz");
    }

    private static URL getURL(String string) {
        URL uRL = null;
        try {
            uRL = new URL("file:" + string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL;
    }

    private static void showError(Component component, String string) {
        JOptionPane.showMessageDialog(component, string, "Error", 0);
    }

    private static String[] getResolutions(DisplayMode[] displayModeArray) {
        ArrayList<String> arrayList = new ArrayList<String>(displayModeArray.length);
        for (int i = 0; i < displayModeArray.length; ++i) {
            String string = displayModeArray[i].getWidth() + " x " + displayModeArray[i].getHeight();
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    private static String[] getDepths(String string, DisplayMode[] displayModeArray) {
        ArrayList<String> arrayList = new ArrayList<String>(4);
        for (int i = 0; i < displayModeArray.length; ++i) {
            if (displayModeArray[i].getBitsPerPixel() < 16) continue;
            String string2 = displayModeArray[i].getWidth() + " x " + displayModeArray[i].getHeight();
            String string3 = String.valueOf(displayModeArray[i].getBitsPerPixel()) + " bpp";
            if (!string2.equals(string) || arrayList.contains(string3)) continue;
            arrayList.add(string3);
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    private static String[] getFrequencies(String string, DisplayMode[] displayModeArray) {
        ArrayList<String> arrayList = new ArrayList<String>(4);
        for (int i = 0; i < displayModeArray.length; ++i) {
            String string2 = displayModeArray[i].getWidth() + " x " + displayModeArray[i].getHeight();
            String string3 = String.valueOf(displayModeArray[i].getFrequency()) + " Hz";
            if (!string2.equals(string) || arrayList.contains(string3)) continue;
            arrayList.add(string3);
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DisplayModeSorter
    implements Comparator<DisplayMode> {
        private DisplayModeSorter() {
        }

        @Override
        public int compare(DisplayMode displayMode, DisplayMode displayMode2) {
            if (displayMode.getWidth() != displayMode2.getWidth()) {
                return displayMode.getWidth() > displayMode2.getWidth() ? 1 : -1;
            }
            if (displayMode.getHeight() != displayMode2.getHeight()) {
                return displayMode.getHeight() > displayMode2.getHeight() ? 1 : -1;
            }
            if (displayMode.getBitsPerPixel() != displayMode2.getBitsPerPixel()) {
                return displayMode.getBitsPerPixel() > displayMode2.getBitsPerPixel() ? 1 : -1;
            }
            if (displayMode.getFrequency() != displayMode2.getFrequency()) {
                return displayMode.getFrequency() > displayMode2.getFrequency() ? 1 : -1;
            }
            return 0;
        }
    }
}

