/*
 * Decompiled with CFR 0.152.
 */
package com.jme.util;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GameTask<V>
implements Future<V> {
    private static final Logger logger = Logger.getLogger(GameTask.class.getName());
    private Callable<V> callable;
    private boolean cancelled;
    private boolean completed;
    private V result;
    private ExecutionException exc;

    public GameTask(Callable<V> callable) {
        this.callable = callable;
    }

    @Override
    public boolean cancel(boolean bl) {
        if (this.result != null) {
            return false;
        }
        this.cancelled = true;
        return true;
    }

    @Override
    public synchronized V get() throws InterruptedException, ExecutionException {
        while (!this.completed && this.exc == null) {
            this.wait();
        }
        if (this.exc != null) {
            throw this.exc;
        }
        return this.result;
    }

    @Override
    public synchronized V get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.completed && this.exc == null) {
            timeUnit.timedWait(this, l);
        }
        if (this.exc != null) {
            throw this.exc;
        }
        if (this.result == null) {
            throw new TimeoutException("Object not returned in time allocated.");
        }
        return this.result;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.completed;
    }

    public Callable<V> getCallable() {
        return this.callable;
    }

    public synchronized void invoke() {
        try {
            this.result = this.callable.call();
            this.completed = true;
        }
        catch (Exception exception) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "invoke()", "Exception", exception);
            this.exc = new ExecutionException(exception);
        }
        this.notifyAll();
    }
}

