/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.client.sample;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.InetSocketAddress;
import java.net.URL;
import jp.sourceforge.mmosf.client.sample.SampleClientFrame;
import jp.sourceforge.mmosf.server.sample.SampleGameServer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;

public class SampleClient3 {
    static Log log = LogFactory.getLog(SampleClient3.class);

    public static void main(String[] args) {
        LogFactory.getFactory().setAttribute("org.apache.commons.logging.log", "org.apache.commons.logging.impl.Log4JLogger");
        URL path = SampleGameServer.class.getClassLoader().getResource("jp/sourceforge/mmosf/client/sample/conf/log4j.properties");
        PropertyConfigurator.configure(path.getPath());
        log.info("client start.");
        SampleClientFrame frame = new SampleClientFrame();
        frame.setDefaultCloseOperation(3);
        try {
            InetSocketAddress addr = SampleClient3.loadConf();
            if (addr == null) {
                addr = new InetSocketAddress("127.0.0.1", 2000);
                log.info("connect 127.0.0.1:2000");
            }
            frame.connect(addr, "admin");
        }
        catch (Exception e) {
            log.error("failed connect gameserver.", e);
        }
        frame.setVisible(true);
        frame.start();
    }

    private static InetSocketAddress loadConf() {
        String[] addr;
        String str;
        block5: {
            File file;
            block4: {
                try {
                    file = new File("client.conf");
                    if (file.exists()) break block4;
                    return null;
                }
                catch (Exception e) {
                    log.error("error in load conf, ", e);
                    return null;
                }
            }
            BufferedReader r = new BufferedReader(new FileReader(file));
            str = r.readLine();
            r.close();
            addr = str.split(":");
            if (addr != null && addr.length == 2) break block5;
            return null;
        }
        log.info("connect " + str);
        return new InetSocketAddress(addr[0], (int)Integer.valueOf(addr[1]));
    }
}

