/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.client.sample.jme;

import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import jp.sourceforge.mmosf.client.sample.jme.JListPanel;
import jp.sourceforge.mmosf.server.object.action.ActionElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMenuPanel
extends JListPanel<JButton>
implements ActionListener {
    private static final long serialVersionUID = 1L;
    protected JLabel label;
    protected List<ActionElement> listAction;
    protected double distance = 0.0;
    protected boolean isReplyMessage;

    public JMenuPanel() {
        this.init();
    }

    public JMenuPanel(LayoutManager arg0) {
        super(arg0);
        this.init();
    }

    public JMenuPanel(boolean arg0) {
        super(arg0);
        this.init();
    }

    public JMenuPanel(LayoutManager arg0, boolean arg1) {
        super(arg0, arg1);
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        BoxLayout layout = new BoxLayout(this, 1);
        this.setLayout(layout);
        this.label = new JLabel();
        this.add(this.label);
    }

    private void setLabelWidth(JComponent comp) {
        Dimension dim = comp.getMaximumSize();
        dim.width = Integer.MAX_VALUE;
        comp.setPreferredSize(dim);
    }

    public void setText(String text) {
        this.label.setText("<html><div style=\"width:100%\">" + text + "</div></html>");
    }

    public void setButton(List<ActionElement> listAction) {
        this.clearComponent();
        this.listAction = listAction;
        for (ActionElement elm : listAction) {
            JButton btn = this.addComponent(JButton.class);
            btn.addActionListener(this);
            btn.setText(elm.name);
            btn.setActionCommand(Integer.toString(elm.id));
            if (!(this.distance > (double)elm.distance)) continue;
            btn.setEnabled(false);
        }
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public boolean isReplyMessage() {
        return this.isReplyMessage;
    }

    public void setReplyMessage(boolean isReplyMessage) {
        this.isReplyMessage = isReplyMessage;
    }

    @Override
    public void resize() {
        this.setLabelWidth(this.label);
        super.resize();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        for (ActionElement act : this.listAction) {
            if (!cmd.equals(Integer.toString(act.id))) continue;
            this.onButton(act);
            break;
        }
    }

    protected void onButton(ActionElement act) {
    }
}

