/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.client.sample.jme;

import java.awt.LayoutManager;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JSplitPane;
import jp.sourceforge.mmosf.client.sample.jme.JListPanel;
import jp.sourceforge.mmosf.client.sample.jme.JQuestPanel;
import jp.sourceforge.mmosf.client.sample.jme.QuestInfo;
import jp.sourceforge.mmosf.server.packet.Packet;
import jp.sourceforge.mmosf.server.packet.PacketFormatException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JQuestListPanel
extends JListPanel<JQuestPanel> {
    private static final long serialVersionUID = 1L;
    protected List<QuestInfo> listQuestInfo;
    protected JSplitPane pane;
    protected JList list;
    protected DefaultListModel listModel;
    protected JLabel label;

    public JQuestListPanel() {
    }

    public JQuestListPanel(LayoutManager layout) {
        super(layout);
    }

    public JQuestListPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    public JQuestListPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    @Override
    protected void init() {
        super.init();
        this.setLayout(new BoxLayout(this, 1));
        this.listQuestInfo = new LinkedList<QuestInfo>();
    }

    public void addNewQuest(Packet packet) throws PacketFormatException {
        JQuestPanel panel = this.addComponent(JQuestPanel.class);
        QuestInfo info = new QuestInfo();
        this.listQuestInfo.add(info);
        info.setQuestPacket(packet);
        panel.setQuestInfo(info);
    }

    public void updateQuest(Packet packet) throws PacketFormatException {
        int questId = packet.getInt("questId");
        for (JQuestPanel questPanel : this.listComponent) {
            QuestInfo questInfo = questPanel.getQuestInfo();
            if (questInfo.getQuestId() != questId) continue;
            questInfo.setQuestPacket(packet);
            break;
        }
    }

    public void removeQuest(Packet packet) throws PacketFormatException {
        int questId = packet.getInt("questId");
        Iterator<QuestInfo> it = this.listQuestInfo.iterator();
        while (it.hasNext()) {
            QuestInfo info = it.next();
            if (info.getQuestId() != questId) continue;
            it.remove();
        }
        this.redrawList();
    }

    protected void redrawList() {
        this.clearComponent();
        for (QuestInfo info : this.listQuestInfo) {
            JQuestPanel panel = this.addComponent(JQuestPanel.class);
            panel.setQuestInfo(info);
        }
    }
}

