/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import jp.sourceforge.mmosf.server.InvalidConnectionException;
import jp.sourceforge.mmosf.server.ListenerManager;
import jp.sourceforge.mmosf.server.MatchingServer;
import jp.sourceforge.mmosf.server.ReceiveThread;
import jp.sourceforge.mmosf.server.SocketManager;
import jp.sourceforge.mmosf.server.UserConnection;
import jp.sourceforge.mmosf.server.loginserver.SingleProcessThread2;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ListeningServer
implements Runnable {
    private static final Log log = LogFactory.getLog(ListeningServer.class);
    protected ListenerManager listener;
    private MatchingServer matching = null;
    protected Map<String, Long> reserveLoginID = null;

    public ListeningServer(int port) throws IOException {
        this.listener = new ListenerManager(port);
        this.reserveLoginID = new HashMap<String, Long>();
    }

    public void run() {
        this.processBlocking2();
    }

    public void processBlocking() {
        while (true) {
            SocketManager socket = null;
            try {
                socket = this.listener.accept();
            }
            catch (IOException e) {
                log.error("error in listening.", e);
                break;
            }
            UserConnection userConnection = null;
            try {
                userConnection = this.createUseConnection(socket);
                this.startReceive(this.GetMatchingServer(), userConnection);
            }
            catch (Exception e) {
                log.error("error in receive.", e);
            }
        }
    }

    public void processBlocking2() {
        SingleProcessThread2 th = new SingleProcessThread2(100);
        new Thread(th).start();
        while (true) {
            SocketManager socket = null;
            try {
                socket = this.listener.accept();
            }
            catch (IOException e) {
                log.error("error in listening.", e);
                break;
            }
            UserConnection userConnection = null;
            try {
                userConnection = this.createUseConnection(socket);
                th.addProcess(new ReceiveThread(this.GetMatchingServer(), userConnection));
            }
            catch (Exception e) {
                log.error("error in receive.", e);
            }
        }
    }

    protected UserConnection createUseConnection(SocketManager manager) throws InvalidConnectionException {
        UserConnection conn = new UserConnection(manager);
        return conn;
    }

    protected void startReceive(MatchingServer matchingServer, UserConnection conn) {
        Thread th = new Thread(new ReceiveThread(matchingServer, conn));
        th.start();
    }

    protected MatchingServer GetMatchingServer() {
        if (this.matching == null) {
            this.matching = new MatchingServer();
        }
        return this.matching;
    }

    public InetSocketAddress getAddress() {
        return new InetSocketAddress("127.0.0.1", this.listener.getLocalPort());
    }

    public void reservLoginID(String connectID) {
        this.reserveLoginID.put(connectID, System.currentTimeMillis());
    }
}

