/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server.object.test;

import jp.sourceforge.mmosf.server.Perception;
import jp.sourceforge.mmosf.server.object.MoveObject;
import jp.sourceforge.mmosf.server.object.MovingVector;
import jp.sourceforge.mmosf.server.object.PlayerCharactor;
import jp.sourceforge.mmosf.server.object.Position;
import jp.sourceforge.mmosf.server.object.Vector;
import jp.sourceforge.mmosf.server.test.TestConnection;
import org.junit.Assert;
import org.junit.Test;

public class TestMobMove
implements Perception {
    @Test
    public void TestPcMove() {
        PlayerCharactor pc = new PlayerCharactor(0, 0, Character.valueOf('A'), 0, new TestConnection(null, null));
        this.testMove(pc, Vector.NORTH);
        this.testMove(pc, Vector.SOUTH);
        this.testMove(pc, Vector.EAST);
        this.testMove(pc, Vector.WEST);
    }

    @Test
    public void TestPcMove3() {
        PlayerCharactor pc = new PlayerCharactor(0, 0, Character.valueOf('A'), 0, new TestConnection(null, null));
        this.testMoveContinual(pc, new Vector(1, 0, 0));
        this.testMoveContinual(pc, new Vector(3, 0, 0));
        Vector v = new Vector();
        v.x = 0.3;
    }

    @Test
    public void TestPcMove4() {
        PlayerCharactor pc = new PlayerCharactor(0, 0, Character.valueOf('A'), 0, new TestConnection(null, null));
        this.testMoveContinual(pc, new Vector(-1, 0, 0));
        this.testMoveContinual(pc, new Vector(-3, 0, 0));
        Vector v = new Vector();
        v.x = -0.3;
    }

    private void testMove(PlayerCharactor pc, Vector v) {
        try {
            pc.setVector(v);
            double speed = ((MovingVector)pc.moving).getSpeed();
            Thread.sleep(1000L);
            Position oldPos = new Position(pc.getPos());
            pc.moving.move(pc, this);
            Position newPos = new Position(pc.getPos());
            newPos.subtract(oldPos);
            Assert.assertEquals((long)((int)((double)v.getX() * speed)), (long)newPos.getX());
            Assert.assertEquals((long)((int)((double)v.getY() * speed)), (long)newPos.getY());
            Assert.assertEquals((long)((int)((double)v.getZ() * speed)), (long)newPos.getZ());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Assert.fail((String)e.toString());
        }
    }

    public boolean isCollision(MoveObject mo) {
        return true;
    }

    public boolean isEnableMove(MoveObject mo) {
        return true;
    }

    private void testMoveContinual(PlayerCharactor pc, Vector v) {
        class TestPerception
        implements Perception {
            Position pos1 = null;
            Position pos2;

            TestPerception() {
            }

            public boolean isCollision(MoveObject mo) {
                if (this.pos1 != null) {
                    int x = this.pos1.getX() - mo.getNowPos().getX();
                    int y = this.pos1.getY() - mo.getNowPos().getY();
                    int z = this.pos1.getZ() - mo.getNowPos().getZ();
                    if (x * x != 1 && y * y != 1 && z * z != 1) {
                        Assert.fail((String)"bad increment collision.");
                    }
                }
                this.pos1 = new Position(mo.getNowPos());
                return true;
            }

            public boolean isEnableMove(MoveObject mo) {
                if (this.pos2 != null) {
                    int x = this.pos2.getX() - mo.getNowPos().getX();
                    int y = this.pos2.getY() - mo.getNowPos().getY();
                    int z = this.pos2.getZ() - mo.getNowPos().getZ();
                    if (x * x != 1 && y * y != 1 && z * z != 1) {
                        Assert.fail((String)"bad increment enableMove.");
                    }
                }
                this.pos2 = new Position(mo.getNowPos());
                return true;
            }
        }
        TestPerception testP = new TestPerception();
        try {
            Position oldPos = new Position(pc.getPos());
            pc.setVector(v);
            double speed = ((MovingVector)pc.moving).getSpeed();
            int second = 5;
            Thread.sleep(1000 * second);
            pc.moving.move(pc, testP);
            Position newPos = new Position(pc.getPos());
            newPos.subtract(oldPos);
            Assert.assertTrue((Math.abs(v.x * speed * (double)second - (double)newPos.getX()) <= Math.abs(v.x) ? 1 : 0) != 0);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Assert.fail((String)e.toString());
        }
    }
}

