/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server.packet;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jp.sourceforge.mmosf.server.level.MessageResource;
import jp.sourceforge.mmosf.server.object.ChatMessage;
import jp.sourceforge.mmosf.server.object.Mob;
import jp.sourceforge.mmosf.server.object.Position;
import jp.sourceforge.mmosf.server.object.Vector;
import jp.sourceforge.mmosf.server.object.action.ActionElement;
import jp.sourceforge.mmosf.server.object.item.Item;
import jp.sourceforge.mmosf.server.object.quest.Quest;
import jp.sourceforge.mmosf.server.packet.ActionPacket;
import jp.sourceforge.mmosf.server.packet.ConnectPacket;
import jp.sourceforge.mmosf.server.packet.HelloPacket;
import jp.sourceforge.mmosf.server.packet.LogPacket;
import jp.sourceforge.mmosf.server.packet.LoginPacket;
import jp.sourceforge.mmosf.server.packet.LogoutPacket;
import jp.sourceforge.mmosf.server.packet.MenuPacket;
import jp.sourceforge.mmosf.server.packet.MessagePacket;
import jp.sourceforge.mmosf.server.packet.MovePacket;
import jp.sourceforge.mmosf.server.packet.Packet;
import jp.sourceforge.mmosf.server.packet.PacketFormatException;
import jp.sourceforge.mmosf.server.packet.QuestPacket;
import jp.sourceforge.mmosf.server.packet.StatusPacket;
import jp.sourceforge.mmosf.server.packet.Type;
import jp.sourceforge.mmosf.server.packet.UpdatePacket;
import jp.sourceforge.mmosf.server.packet.XmlPacketFormatter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PacketFactory {
    private static final Log log = LogFactory.getLog(PacketFactory.class);
    protected static Type type = new Type();

    public static Packet createMessagePacket(ChatMessage message) {
        MessagePacket packet = (MessagePacket)PacketFactory.createPacket(2);
        if (packet == null) {
            return null;
        }
        packet.setInt("type", message.type);
        if (message.speaker != null) {
            packet.setString("speaker", message.speaker);
        }
        if (message.message == null) {
            packet.setInt("MESSAGEID", message.id);
        } else {
            packet.setString("MESSAGE", message.message);
        }
        return packet;
    }

    public static ChatMessage parseMessagePacket(MessagePacket packet) throws PacketFormatException {
        int type = packet.getInt("type");
        String speaker = packet.getString("speaker");
        String str = packet.getString("MESSAGE");
        if (str != null) {
            return new ChatMessage(type, speaker, str);
        }
        int id = packet.getInt("MESSAGEID");
        return new ChatMessage(type, speaker, MessageResource.getString(id));
    }

    public static Packet createLogoutPacket(boolean isOk) {
        LogoutPacket packet = (LogoutPacket)PacketFactory.createPacket(1);
        if (packet == null) {
            return null;
        }
        packet.setBoolean("SUCCESS", isOk);
        return packet;
    }

    static Packet createPacket(int type) {
        try {
            Packet packet = PacketFactory.type.createObject(type);
            XmlPacketFormatter formatter = new XmlPacketFormatter();
            formatter.create(type);
            packet.setFormatter(formatter);
            return packet;
        }
        catch (Exception e) {
            log.error("XmlPacketFormatter create error.", e);
            return null;
        }
    }

    public static Packet parsePacket(ByteBuffer buff) {
        try {
            XmlPacketFormatter formatter = new XmlPacketFormatter();
            formatter.parse(buff);
            int type = formatter.getType();
            Packet packet = PacketFactory.type.createObject(type);
            packet.setFormatter(formatter);
            return packet;
        }
        catch (Exception e) {
            log.error("invalid formatter id.", e);
            return null;
        }
    }

    public static Packet createNoopPacket() {
        return PacketFactory.createPacket(3);
    }

    public static Packet createLoginSuccessPcaket(InetSocketAddress addr, String LoginID) {
        LoginPacket packet = (LoginPacket)PacketFactory.createPacket(0);
        if (packet == null) {
            return null;
        }
        packet.setBoolean("success", true);
        packet.setString("hostadress", addr.getAddress().getHostAddress());
        packet.setString("loginPort", Integer.toString(addr.getPort()));
        packet.setString("connectid", LoginID);
        return packet;
    }

    public static Packet createLoginFailurePcaket() {
        LoginPacket packet = (LoginPacket)PacketFactory.createPacket(0);
        if (packet == null) {
            return null;
        }
        packet.setBoolean("success", false);
        return packet;
    }

    public static Packet createLoginRequestPcaket(String id, String password, String random) throws NoSuchAlgorithmException {
        LoginPacket packet = (LoginPacket)PacketFactory.createPacket(0);
        if (packet == null) {
            return null;
        }
        String string = LoginPacket.digest(String.valueOf(password) + random);
        packet.setString("userId", id);
        packet.setString("password", string);
        return packet;
    }

    public static Packet createHelloPcaket(String random) throws NoSuchAlgorithmException {
        HelloPacket packet = (HelloPacket)PacketFactory.createPacket(4);
        if (packet == null) {
            return null;
        }
        if (random != null) {
            packet.setString("random", random);
        }
        return packet;
    }

    public static Packet createConnectRequestPcaket(String connectId) {
        ConnectPacket packet = (ConnectPacket)PacketFactory.createPacket(5);
        if (packet == null) {
            return null;
        }
        packet.setString("connectid", connectId);
        return packet;
    }

    public static Packet createConnectResponsePcaket(int id, boolean isSuccess) {
        ConnectPacket packet = (ConnectPacket)PacketFactory.createPacket(5);
        if (packet == null) {
            return null;
        }
        packet.setBoolean("success", isSuccess);
        packet.setInt("charactorid", id);
        return packet;
    }

    public static Packet createUpdatePacket(List<Mob> listUpdate, List<Mob> listDelete) {
        UpdatePacket packet = (UpdatePacket)PacketFactory.createPacket(6);
        if (packet == null) {
            return null;
        }
        PacketFactory.setMobList(packet, listUpdate, "update");
        PacketFactory.setMobList(packet, listDelete, "delete");
        return packet;
    }

    private static void setMobList(UpdatePacket packet, List<Mob> listMob, String prefix) {
        int count = 0;
        for (Mob mob : listMob) {
            String prefix2 = String.valueOf(prefix) + Integer.toString(count);
            packet.setString(prefix2, "x", Integer.toString(mob.getPos().getX()));
            packet.setString(prefix2, "y", Integer.toString(mob.getPos().getY()));
            packet.setString(prefix2, "c", Character.toString(mob.c));
            packet.setString(prefix2, "mobid", Integer.toString(mob.getId()));
            packet.setString(prefix2, "mobtype", Integer.toString(mob.type));
            packet.setString(prefix2, "v", Integer.toString(mob.vis.getVtype()));
            packet.setString(prefix2, "d-x", Integer.toString(mob.direction.getX()));
            packet.setString(prefix2, "d-y", Integer.toString(mob.direction.getY()));
            ++count;
        }
    }

    public static void parseUpdatePacket(UpdatePacket packet, List<Mob> listUpdate, List<Mob> listDelete) throws PacketFormatException {
        PacketFactory.getMobList(listUpdate, packet, "update");
        PacketFactory.getMobList(listDelete, packet, "delete");
    }

    private static void getMobList(List<Mob> list, UpdatePacket packet, String prefix) throws PacketFormatException {
        String prefix2;
        String value;
        int count = 0;
        while ((value = packet.getString(prefix2 = String.valueOf(prefix) + Integer.toString(count), "x")) != null) {
            int x = Integer.parseInt(value);
            int y = Integer.parseInt(packet.getString(prefix2, "y"));
            char c = packet.getString(prefix2, "c").charAt(0);
            int id = Integer.parseInt(packet.getString(prefix2, "mobid"));
            int type = Integer.parseInt(packet.getString(prefix2, "mobtype"));
            int v = Integer.parseInt(packet.getString(prefix2, "v"));
            int dx = Integer.parseInt(packet.getString(prefix2, "d-x"));
            int dy = Integer.parseInt(packet.getString(prefix2, "d-y"));
            Mob mob = new Mob(x, y, Character.valueOf(c), id, v);
            mob.direction.x = dx;
            mob.direction.y = dy;
            mob.type = type;
            list.add(mob);
            ++count;
        }
    }

    public static Packet createMovePacket(Vector v) {
        MovePacket packet = (MovePacket)PacketFactory.createPacket(7);
        if (packet == null) {
            return null;
        }
        packet.setVector(v);
        return packet;
    }

    public static Packet createMoveResponsePacket(Vector v, Position pos, double speed) {
        MovePacket packet = (MovePacket)PacketFactory.createPacket(7);
        if (packet == null) {
            return null;
        }
        packet.setVector(v);
        packet.setPosition(pos);
        packet.setString("speed", Double.toString(speed));
        return packet;
    }

    public static Packet createMenuRequestPaket(Mob mob) {
        MenuPacket packet = (MenuPacket)PacketFactory.createPacket(8);
        if (packet == null) {
            return null;
        }
        packet.setInt("type", 0);
        packet.setInt("id", mob.getId());
        return packet;
    }

    public static Packet createMenuRequestPaket(int slot) {
        MenuPacket packet = (MenuPacket)PacketFactory.createPacket(8);
        if (packet == null) {
            return null;
        }
        packet.setInt("type", 1);
        packet.setInt("slot", slot);
        return packet;
    }

    public static Packet createMenuResponsePaket(String target, String text, List<ActionElement> list) {
        MenuPacket packet = (MenuPacket)PacketFactory.createPacket(8);
        if (packet == null) {
            return null;
        }
        packet.setString("target", target);
        if (text != null) {
            packet.setString("text", text);
        }
        Iterator<ActionElement> it = list.iterator();
        int count = 0;
        while (it.hasNext()) {
            ActionElement ae = it.next();
            String prefix = "x" + Integer.toString(count);
            packet.setString(prefix, "name", ae.name);
            packet.setInt(prefix, "id", ae.id);
            packet.setString(prefix, "distance", Float.toString(ae.distance));
            ++count;
        }
        return packet;
    }

    public static List<ActionElement> parseMenuResponsePacket(MenuPacket packet) throws PacketFormatException {
        String prefix;
        String value;
        LinkedList<ActionElement> list = new LinkedList<ActionElement>();
        int count = 0;
        while ((value = packet.getString(prefix = "x" + Integer.toString(count), "name")) != null) {
            int id = packet.getInt(prefix, "id");
            float distance = Float.valueOf(packet.getString(prefix, "distance")).floatValue();
            list.add(new ActionElement(id, value, distance));
            ++count;
        }
        return list;
    }

    public static Packet createActionPacket(Mob mob, ActionElement act) {
        ActionPacket packet = (ActionPacket)PacketFactory.createPacket(10);
        if (packet == null) {
            return null;
        }
        packet.setInt("type", 0);
        packet.setInt("targetid", mob.getId());
        packet.setInt("commandid", act.id);
        return packet;
    }

    public static Packet createActionPacket(int slot, ActionElement act) {
        ActionPacket packet = (ActionPacket)PacketFactory.createPacket(10);
        if (packet == null) {
            return null;
        }
        packet.setInt("type", 1);
        packet.setInt("slotid", slot);
        packet.setInt("commandid", act.id);
        return packet;
    }

    public static Packet createGetItemStatusPacket(int slot, Item item) {
        StatusPacket packet = (StatusPacket)PacketFactory.createPacket(9);
        if (packet == null) {
            return null;
        }
        packet.setInt("type", 0);
        String prefix = "item0";
        packet.setInt(prefix, "slot", slot);
        packet.setInt(prefix, "id", item.id);
        packet.setString(prefix, "name", item.name);
        packet.setString(prefix, "serialno", Long.toString(item.serialNo));
        return packet;
    }

    public static Map.Entry<Integer, Item> parseGetItemStatusPacket(StatusPacket packet) throws PacketFormatException {
        String prefix = "item0";
        HashMap<Integer, Item> ret = new HashMap<Integer, Item>();
        int slot = packet.getInt(prefix, "slot");
        int id = packet.getInt(prefix, "id");
        String name = packet.getString(prefix, "name");
        long serialno = Long.valueOf(packet.getString(prefix, "serialno"));
        Item item = new Item(id, name, serialno);
        ret.put(slot, item);
        return ret.entrySet().iterator().next();
    }

    public static Packet createQuestPacket(Quest quest) {
        QuestPacket packet = (QuestPacket)PacketFactory.createPacket(11);
        if (packet == null) {
            return null;
        }
        packet.setInt("questId", quest.id);
        packet.setString("name", quest.name);
        int progress = 0;
        if (quest.isComplete()) {
            progress = 2;
        } else if (quest.indexPhase != 0) {
            progress = 1;
        }
        packet.setInt("progress", progress);
        switch (progress) {
            case 0: {
                packet.setString("premsg", quest.getPhase().preMessage);
                break;
            }
            case 1: {
                packet.setString("postmsg", quest.getPrevPhase().postMessage);
                packet.setString("premsg", quest.getPhase().preMessage);
                break;
            }
            case 2: {
                packet.setString("postmsg", quest.postMessage);
            }
        }
        return packet;
    }

    public static Packet createLogPacket(String string) {
        LogPacket packet = (LogPacket)PacketFactory.createPacket(12);
        if (packet == null) {
            return null;
        }
        packet.setString("message", string);
        return packet;
    }
}

