/*
    mod_bbs Multi Thread BBS Engine
    Copyright (C)2003 1000GEX Project 1000gex@1000gex.net
*/

static void error_html(request_rec *r, const char *message)
{
    ap_rprintf(r,
                "<html>"
                "<head>"
                "<title>G[ł mod_bbs</title>"
                "</head>"
                "<body>"
                "<b><font color=red>G[܂</font></b><br>"
                "<br>%s"
                "</body>"
                "</html>"
                ,message
            );
}

int safe_strlen(char *string)
{
    int len = 0;
    if(string == NULL || string == "\0"){
        len = 0;
    }
    else{
        len = strlen(string);
    }
    return len;
}

int get_res_num(request_rec *r, char *string)
{
    const char *left = "(";
    const char *right = ")";
    int i;
    int left_pos = 0;
    int right_pos = 0;
    int len;
    int res_num;
    char *p;
    char *new_string;
    char *buf;
    
    len = safe_strlen(string);
    buf = ap_pcalloc(r->pool, len + 1);
    p = ap_pstrdup(r->pool, string);

    for(i=0;i<len;i++){
        buf[0] = p[i];
        if(!strcmp(buf,left)){
            left_pos = i;
            new_string = p + i + 1;
            p[len] = '\0'; /* sR|h\0܂ނ̂-3 */
            break;
        }
    }
    res_num = atoi(new_string);

    return res_num;
}

static table *request_token(pool *p, char *src)
{
    table *param;
    char *token;
    char *args = src;

    param = ap_make_table(p, 1);
    while (*args && (token = ap_getword_nc(p,&args,'&'))) {
        char *key, *value;
        key = ap_getword_nc(p,&token, '=');
        value = ap_getword_nc(p, &token, '=');
        ap_unescape_url(key);
        ap_unescape_url(value);
        ap_table_set(param,key,value);
    }
    return param;
}

static table *get_request_body(request_rec *r)
{
    char *body;
    long length;
    char buff[HUGE_STRING_LEN];
    int rsize;
    int len_read;
    int rpos = 0;
    int *return_string;

#if DEBUG
    ap_rprintf(r, "<b>body</b>:[%s]<br>", body);
#endif

    if(ap_setup_client_block(r, REQUEST_CHUNKED_ERROR)){
        return NULL;
    }
    if(!ap_should_client_block(r)){
        return NULL;
    }

    length = r->remaining;
    body = ap_palloc(r->pool, length + 1);
    while((len_read = ap_get_client_block(r, buff, sizeof(buff))) > 0){
        if((rpos + len_read) > length){
            rsize = length - rpos;
        }
        else{
            rsize = len_read;
        }
        memmove(body + rpos, buff, rsize);
        rpos += rsize;
    }

    //body = escape_break(r->pool, body);

    return request_token(r->pool, body);
}

subject_t *ap_psubtoken(pool *p, char *string)
{
    int i = 0;
    int count = 0;
    int num = 0;
    subject_t *sub;
    
    sub = ap_pcalloc(p, sizeof(subject_t));
    if(string == NULL){
        return sub;
    }
    num = safe_strlen(string) - 2;
    sub->dat = string;
    for(i=0;i<num;i++){
        if( (string[0] == '<') && (string[1] == '>') ){
                sub->title = string + 2;
                string[0] = '\0';
                string[1] = '\0';
                count++;
                break;
        }
        string++;
    }
    return sub;
}

void bbs_html_escape(pool *p,bbs_t *bbs)
{
	bbs->bbs = ap_escape_html2(p, bbs->bbs);
	bbs->key = ap_escape_html2(p, bbs->key);
	bbs->subject = ap_escape_html2(p, bbs->subject);
	bbs->from = ap_escape_html2(p, bbs->from);
	bbs->mail = ap_escape_html2(p, bbs->mail);
	bbs->message = ap_escape_html2(p, bbs->message);
}

API_EXPORT(char *) ap_escape_html2(pool *p, const char *s)
{
    int i, j;
    char *x;

    /* first, count the number of extra characters */
    for (i = 0, j = 0; s[i] != '\0'; i++)
	if (s[i] == '<' || s[i] == '>' || s[i] == '\n')
	    j += 3;
	else if (s[i] == '&')
	    j += 4;

    if (j == 0)
	return ap_pstrndup(p, s, i);

    x = ap_palloc(p, i + j + 1);
    for (i = 0, j = 0; s[i] != '\0'; i++, j++)
	if (s[i] == '<') {
	    memcpy(&x[j], "&lt;", 4);
	    j += 3;
	}
	else if (s[i] == '>') {
	    memcpy(&x[j], "&gt;", 4);
	    j += 3;
	}
	else if (s[i] == '\r') {
		j--;
	}
	else if (s[i] == '\n') {
	    memcpy(&x[j], "<br>", 4);
	    j += 3;
	}
	else if (s[i] == '&') {
	    memcpy(&x[j], "&amp;", 5);
	    j += 4;
	}
	else
	    x[j] = s[i];

    x[j] = '\0';
    return x;
}
