/*
	mod_bbs Multi Thread BBS Engine
	Copyright (C)2003 1000GEX Project 1000gex@1000gex.net
*/
#include "mod_bbs.h"

static void bbs_init_handler(server_rec *s, pool *p)
{
	ap_add_version_component("BBS/" BBS_VERSION);
}


/* The sample content handler */
static int bbs_handler(request_rec *r)
{
	bbs_t *bbs;
	bbs = ap_get_module_config(r->per_dir_config, &bbs_module);
	
	r->content_type = "text/html";
	r->content_encoding = "Shift_JIS";
	ap_send_http_header(r);
	
	if(bbs->flag == 0){
		return DECLINED;
	}
	if(r->method_number == M_GET){
		bbs_read(bbs, r);
		return OK;
	}
	else if(r->method_number == M_POST){
		bbs_post(bbs, r);
		return OK;
	}
	else{
		return BAD_REQUEST;
	}

	return OK;
}





static void bbs_read2(table *param, request_rec *r)
{

	r->content_type = "text/html";
	ap_send_http_header(r);
	ap_rprintf(r,"name -> %s<br>unko -> %s <br>\n",ap_table_get(param,"name"),ap_table_get(param,"unko"));
}

static const char *cmd_set_flag(cmd_parms *parms, void *mconfig, const char *flag)
{
	bbs_t *bbs;
	bbs = mconfig;
	if(!strcasecmp(flag,"on")){
		bbs->flag = 1;
	}
	else if(!strcasecmp(flag,"off")){
		bbs->flag = 0;
	}
	return NULL;
}

static const char *cmd_set_title(cmd_parms *parms, void *mconfig, char *title)
{
	bbs_t *bbs;
	bbs = mconfig;
	if(title == NULL){
		bbs->title = ap_pstrdup(parms->pool,"POOOfdwf");
	}
	else{
		bbs->title = ap_pstrdup(parms->pool,title);
	}
	return NULL;
}

static const char *cmd_set_noname(cmd_parms *parms, void *mconfig, char *noname)
{
	bbs_t *bbs;
	bbs = mconfig;
	if(noname == NULL){
		bbs->noname = ap_pstrdup(parms->pool,"");
	}
	else{
		bbs->noname = ap_pstrdup(parms->pool,noname);
	}
	return NULL;
}

static void *create_per_dir_config(pool *p, char *arg)
{
	bbs_t *bbs;
	bbs = ap_palloc(p, sizeof(bbs_t));
	bbs->flag = 0;
	bbs->title = ap_pstrdup(p,"mod_bbs BBS Engine for Apache Web Server");
	bbs->noname = ap_pstrdup(p,"Default");
	return (void *)bbs;
}

static const command_rec cmds[] =
{
	{"BBS", cmd_set_flag, NULL, ACCESS_CONF, TAKE1, "bbs flog"},
	{"BBSTitle" , cmd_set_title, NULL, ACCESS_CONF, TAKE1, "bbs title"},
	{"BBSNoName", cmd_set_noname, NULL,ACCESS_CONF, TAKE1, "bbs noname"},
	{ NULL }
};


/* Dispatch list of content handlers */
static const handler_rec bbs_handlers[] = {
    { "bbs", bbs_handler },
    { NULL, NULL }
};

/* Dispatch list for API hooks */
module MODULE_VAR_EXPORT bbs_module = {
    STANDARD_MODULE_STUFF, 
    bbs_init_handler,                  /* module initializer                  */
    create_per_dir_config,/* create per-dir    config structures */
    NULL,                  /* merge  per-dir    config structures */
    NULL,                  /* create per-server config structures */
    NULL,                  /* merge  per-server config structures */
    cmds,                  /* table of config file commands       */
    bbs_handlers,          /* [#8] MIME-typed-dispatched handlers */
    NULL,                  /* [#1] URI to filename translation    */
    NULL,                  /* [#4] validate user id from request  */
    NULL,                  /* [#5] check if the user is ok _here_ */
    NULL,                  /* [#3] check access by host address   */
    NULL,                  /* [#6] determine MIME type            */
    NULL,                  /* [#7] pre-run fixups                 */
    NULL,                  /* [#9] log a transaction              */
    NULL,                  /* [#2] header parser                  */
    NULL,                  /* child_init                          */
    NULL,                  /* child_exit                          */
    NULL                   /* [#0] post read-request              */
};

