#!/usr/bin/env perl
###############################################################################
# Copyright (C) 2006 Tetsuya Kimata <kimata@acapulco.dyndns.org>
#
# All rights reserved.
#
# This software is provided 'as-is', without any express or implied
# warranty.  In no event will the authors be held liable for any
# damages arising from the use of this software.
#
# Permission is granted to anyone to use this software for any
# purpose, including commercial applications, and to alter it and
# redistribute it freely, subject to the following restrictions:
#
# 1. The origin of this software must not be misrepresented; you must
#    not claim that you wrote the original software. If you use this
#    software in a product, an acknowledgment in the product
#    documentation would be appreciated but is not required.
#
# 2. Altered source versions must be plainly marked as such, and must
#    not be misrepresented as being the original software.
#
# 3. This notice may not be removed or altered from any source
#    distribution.
#
# $Id: mac_make.pl 1861 2006-10-22 05:05:14Z svn $
###############################################################################

use strict;

use Expect;
use Term::ReadLine;

use constant CMD_TIMEOUT_SEC    => 10;
use constant MAKE_TIMEOUT_SEC   => 3600;
use constant MAC_HOSTNAME       => 'blendy';
use constant MOD_FASTBBS_PATH   => 'Documents/prog/Apache/FastBBS';

sub create_exp {
    my $exp = Expect->new();
    $exp->raw_pty(0);
    return $exp;
}

sub ssh_login {
    my $exp = shift;

    $exp->spawn('ssh', MAC_HOSTNAME) or die $!;
    $exp->expect(CMD_TIMEOUT_SEC, MAC_HOSTNAME . '%');
}

sub cd_top_dir {
    my $exp = shift;

    $exp->send('cd ' . MOD_FASTBBS_PATH . "\n");
    $exp->expect(CMD_TIMEOUT_SEC, MAC_HOSTNAME . '%');
}

sub svn_update {
    my $exp = shift;

    $exp->send('eval `ssh-agent`; ssh-add ~/.ssh/svn.id_rsa; svn update' . "\n");
    $exp->expect(CMD_TIMEOUT_SEC, MAC_HOSTNAME . '%');
}

sub make_config {
    my $exp = shift;

    $exp->send('./configure' . "\n");
    $exp->expect(MAKE_TIMEOUT_SEC, '@' . MAC_HOSTNAME . '%');

    $exp->send('export MACOSX_DEPLOYMENT_TARGET=10.4' . "\n");
    $exp->expect(CMD_TIMEOUT_SEC, MAC_HOSTNAME . '%');
}

sub cd_src_dir {
    my $exp = shift;

    $exp->send('cd src' . "\n");
    $exp->expect(CMD_TIMEOUT_SEC, MAC_HOSTNAME . '%');
}

sub make_check {
    my $exp = shift;
    my $cc = shift;

    $exp->send('make clean' . "\n");
    $exp->expect(MAKE_TIMEOUT_SEC, MAC_HOSTNAME . '%');

    $exp->send('make clean-test-data' . "\n");
    $exp->expect(MAKE_TIMEOUT_SEC, MAC_HOSTNAME . '%');

    $exp->send('make' . "\n");
    $exp->expect(MAKE_TIMEOUT_SEC, MAC_HOSTNAME . '%');

    $exp->send('make clean-obj' . "\n");
    $exp->expect(MAKE_TIMEOUT_SEC, MAC_HOSTNAME . '%');

    $exp->send('make cgi_fast_bbs.app' . "\n");
    $exp->expect(MAKE_TIMEOUT_SEC, MAC_HOSTNAME . '%');

    $exp->send('make clean-obj' . "\n");
    $exp->expect(MAKE_TIMEOUT_SEC, MAC_HOSTNAME . '%');

    $exp->send('make test-run' . "\n");
    $exp->expect(MAKE_TIMEOUT_SEC, MAC_HOSTNAME . '%');
}

my $user = $ENV{'USER'};
my $exp = create_exp();

# 
ssh_login($exp);
# ǥ쥯ȥΰư
cd_top_dir($exp);
# åץǡ
svn_update($exp);
# 
make_config($exp);
# ǥ쥯ȥΰư
cd_src_dir($exp);
# ѥ
make_check($exp);

# Local Variables:
# mode: cperl
# coding: euc-japan-unix
# End:
