#!/usr/bin/env perl
###############################################################################
# Copyright (C) 2006 Tetsuya Kimata <kimata@acapulco.dyndns.org>
#
# All rights reserved.
#
# This software is provided 'as-is', without any express or implied
# warranty.  In no event will the authors be held liable for any
# damages arising from the use of this software.
#
# Permission is granted to anyone to use this software for any
# purpose, including commercial applications, and to alter it and
# redistribute it freely, subject to the following restrictions:
#
# 1. The origin of this software must not be misrepresented; you must
#    not claim that you wrote the original software. If you use this
#    software in a product, an acknowledgment in the product
#    documentation would be appreciated but is not required.
#
# 2. Altered source versions must be plainly marked as such, and must
#    not be misrepresented as being the original software.
#
# 3. This notice may not be removed or altered from any source
#    distribution.
#
# $Id: win_make.pl 1817 2006-10-18 16:20:18Z svn $
###############################################################################

use strict;

use Expect;
use Term::ReadLine;
use Term::ReadPassword;

use constant CMD_TIMEOUT_SEC    => 2;
use constant MAKE_TIMEOUT_SEC   => 3600;
use constant WINDOWS_HOSTNAME   => 'brazil';
use constant VSVARS_PATH        => 'C:/Develop/IDE/VisualStudio/Common7/Tools/vsvars32.bat';
use constant ICLVARS_PATH       => 'C:/Develop/Language/C++/Intel/Compiler/C++/9.1/IA32/Bin/iclvars.bat';
use constant DISK_DEVICE        => 'Z:';
use constant DISK_PATH          => '\\\\columbia\\kimata';
use constant MOD_FASTBBS_PATH   => 'Z:/prog/Apache/FastBBS';

sub get_pass {
    return read_password(qq|pass: |);
}

sub create_exp {
    my $exp = Expect->new();
    $exp->raw_pty(0);
    return $exp;
}

sub ssh_login {
    my $exp = shift;
    my $pass = shift;

    $exp->spawn('ssh', WINDOWS_HOSTNAME) or die $!;
    $exp->expect(CMD_TIMEOUT_SEC, 'password:');
    $exp->send($pass . "\n");
    $exp->expect(CMD_TIMEOUT_SEC, 'successfully');
}

sub mount_disk {
    my $exp = shift;
    my $user = shift;
    my $pass = shift;

    $exp->send('net use ' . DISK_DEVICE . ' ' . quotemeta(DISK_PATH) .
               ' /USER:' . $user . " | nkf -e\n");
    $exp->expect(CMD_TIMEOUT_SEC, '>');
}

sub cd_src_dir {
    my $exp = shift;

    $exp->send('cd ' . MOD_FASTBBS_PATH . '/src' . "\n");
    $exp->expect(CMD_TIMEOUT_SEC, '>');
}

sub set_env {
    my $exp = shift;
    my $cc = shift;

    $exp->send('cmd' . "\n");
    $exp->expect(CMD_TIMEOUT_SEC, '>');

    $exp->send(VSVARS_PATH . "\n");
    $exp->expect(CMD_TIMEOUT_SEC, '>');

    if ($cc eq 'icc') {
        $exp->send(ICLVARS_PATH . "\n");
        $exp->expect(CMD_TIMEOUT_SEC, '>');
    }
}

sub make_check {
    my $exp = shift;
    my $cc = shift;

    $exp->send('make -f GNUmakefile.win32 clean CC=' . $cc .
               ' 2>&1 | nkf -e' . "\n");
    $exp->expect(MAKE_TIMEOUT_SEC, 'src>');

    $exp->send('make -f GNUmakefile.win32 clean-test-data CC=' . $cc .
               ' 2>&1 | nkf -e' . "\n");
    $exp->expect(MAKE_TIMEOUT_SEC, 'src>');

    $exp->send('make -f GNUmakefile.win32 CC=' . $cc .
               ' 2>&1 | nkf -e' . "\n");
    $exp->expect(MAKE_TIMEOUT_SEC, 'src>');

    $exp->send('make -f GNUmakefile.win32 clean-obj CC=' . $cc .
               ' 2>&1 | nkf -e' . "\n");
    $exp->expect(MAKE_TIMEOUT_SEC, 'src>');

    $exp->send('make -f GNUmakefile.win32 cgi_fast_bbs.app.exe CC=' . $cc .
               ' 2>&1 | nkf -e' . "\n");
    $exp->expect(MAKE_TIMEOUT_SEC, 'src>');

    $exp->send('make -f GNUmakefile.win32 clean-obj CC=' . $cc .
               ' 2>&1 | nkf -e' . "\n");
    $exp->expect(MAKE_TIMEOUT_SEC, 'src>');

    $exp->send('make -f GNUmakefile.win32 test-run CC=' . $cc.
               ' 2>&1 | nkf -e' . "\n");
    $exp->expect(MAKE_TIMEOUT_SEC, 'src>');
}

my $user = $ENV{'USER'};
my $cc   = shift @ARGV || 'cl';
my $pass = $ENV{'WIN_PASS'} || get_pass();
my $exp = create_exp();

# 
ssh_login($exp, $pass);
# ǥΥޥ
mount_disk($exp, $user, $pass);
# ǥ쥯ȥΰư
cd_src_dir($exp);
# ĶѿΥå
set_env($exp, $cc);
# ѥ
make_check($exp, $cc);

# Local Variables:
# mode: cperl
# coding: euc-japan-unix
# End:
