var COMMENT_LINK_REGEX = new RegExp("&gt;&gt;((?:\\d+(?:-\\d+)?,)*\\d+(?:-\\d+)?)", "g");
var URL_LINK_REGEX = new RegExp("((?:https?|ftp)://[\\w-]+\\.[\\w-.:]+(?:/[^\\s()\\[\\]{}!\"'<>:,\x7f-\xff]*)?)", "g");

/**
 * ꤵ줿ȥ饹ʤ륨Ȥ֤ޤ
 *
 * @param {String} tag_name ̾
 * @param {String} class_name 饹̾
 * @return Ȥ
 */
function get_node_list(tag_name, class_name)
{
    var tag_list = document.getElementsByTagName(tag_name);
    var tag_class_list = new Array();

    for (var i = 0; i < tag_list.length; i++) {
        if ((tag_list[i].getAttribute("class") == class_name) ||
             tag_list[i].getAttribute("className") == class_name) {
            tag_class_list.push(tag_list[i]);
        }
    }

    return tag_class_list;
}

/**
 * åɤ֤ޤ
 *
 * @return åɤ
 */
function get_thread_list()
{
    return get_node_list("div", "thread_comment");
}

/**
 * å ID֤ޤ
 *
 * @param {Array} thread å
 * @return å ID
 */
function get_thread_id(thread)
{
    return thread.getAttribute("id").replace(/^thread_id_(\d+)$/, "$1");
}

/**
 * Ȥ֤ޤ
 *
 * @param {Array} thread å
 * @return Ȥ
 */
function get_comment_list(thread)
{
    return document.getElementsByTagName("pre");
}

/**
 * åɤФƼư󥯽Ԥޤ
 *
 * @param {String} nase_url ١ URL
 * @param {Array} thread å
 */
function auto_link_thread(base_url, thread)
{
    var thread_id = get_thread_id(thread);
    var comment_list = get_comment_list(thread);

    for (var i = 0; i < comment_list.length; i++) {
        auto_link_comment(base_url, thread_id, comment_list[i]);
    }
}

/**
 * ȤФƼư󥯽Ԥޤ
 *
 * @param {String} nase_url ١ URL
 * @param {String} thread_id å ID
 * @param {Array} comment 
 */
function auto_link_comment(base_url, thread_id, comment)
{
    // 夷ƤΤǡIE Ȥνɬס
    comment.innerHTML = comment.innerHTML.replace(/\n/g, "<br />");

    auto_link_url_link(base_url, thread_id, comment);
    auto_link_comment_link(base_url, thread_id, comment);

    // 夷ƤΤǡIE Ȥνɬס
    comment.innerHTML = comment.innerHTML.replace(/<br \/>/g, "&nbsp;<br />");
}

/**
 * Ȥؤμư󥯽Ԥޤ
 *
 * @param {String} base_url ١ URL
 * @param {String} thread_id å ID
 * @param {Element} comment 
 */
function auto_link_comment_link(base_url, thread_id, comment)
{
    comment.innerHTML = comment.innerHTML.replace
        (COMMENT_LINK_REGEX,
         "<a href=\"" + base_url + "/comment/" + thread_id +
         "/$1\">&gt;&gt;$1</a>");
}

/**
 * URL ؤμư󥯽Ԥޤ
 *
 * @param {String} base_url ١ URL
 * @param {String} thread_id å ID
 * @param {Element} comment 
 */
function auto_link_url_link(base_url, thread_id, comment)
{
    comment.innerHTML = comment.innerHTML.replace
        (URL_LINK_REGEX, "<a href=\"$1\">$1</a>");
}

/**
 * ƤΥåɤΥȤФƼư󥯽Ԥޤ
 *
 * @param {String} nase_url ١ URL
 */
function auto_link(base_url)
{
    var thread_list = get_thread_list();

    for (var i = 0; i < thread_list.length; i++) {
        auto_link_thread(base_url, thread_list[i]);
    }
}

// Local Variables:
// mode: javascript-generic
// coding: euc-japan-unix
// End:
