/******************************************************************************
 * Copyright (C) 2006 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: Path.cpp 2016 2006-11-21 15:21:48Z svn $
 *****************************************************************************/

#include "Environment.h"

#include "apr_file.h"

#include "Path.h"
#include "SourceInfo.h"

SOURCE_INFO_ADD("$Id: Path.cpp 2016 2006-11-21 15:21:48Z svn $");

/******************************************************************************
 * public メソッド
 *****************************************************************************/
bool Path::is_exist(apr_pool_t *pool, const char *path)
{
    apr_finfo_t info;
    apr_status_t status;

//     APR_DECLARE(apr_status_t) apr_stat(apr_finfo_t *finfo, const char *fname,
//                                        apr_int32_t wanted, apr_pool_t *cont);
//     APR_STATUS_IS_EACCES
//         APR_STATUS_IS_ENOENT


    status = apr_stat(&finfo, path, APR_FINFO_NAME, pool);
    if (APR_STATUS_IS_EACCES()) {

    } else if (APR_STATUS_IS_ENOENT(status)) {
        return false;
    } else {
        return true;
    }
}

bool Path::is_writable(apr_pool_t *pool, const char *path)
{
    if (!is_exist(pool, path)) {
        return false;
    }

    
}

// Local Variables:
// mode: c++
// coding: utf-8-dos
// End:
