/******************************************************************************
 * Copyright (C) 2006 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: cgi_fast_bbs.cpp 2029 2006-11-23 11:12:51Z svn $
 *****************************************************************************/

/**
 * @file
 * @brief CGI のエントリ関数群．
 */
#include "Environment.h"

#include <cstdlib>

#include "AtomicWrapper.h"
#include "apr_env.h"

#include "fast_bbs_handler.h"

#include "BBSConfig.h"
#include "BBSConfigReader.h"
#include "CGIResponse.h"
#include "CGILogger.h"
#include "Auxiliary.h"
#include "Message.h"
#include "SourceInfo.h"

#define TEMPLATE_INSTANTIATION
#define RESPONSE_TYPE_CGI
#include "fast_bbs_handler.cpp"

SOURCE_INFO_ADD("$Id: cgi_fast_bbs.cpp 2029 2006-11-23 11:12:51Z svn $");

static const char *CON_FILE_PATH    = "./fast_bbs.conf";

void bbs_main(apr_pool_t *pool)
{
    BBSConfig *config;
    char *path_info;

    config = BBSConfigReader::read(pool, CON_FILE_PATH);
    config->init();

    if (apr_env_get(&path_info, "PATH_INFO", pool) != APR_SUCCESS) {
        path_info = const_cast<char *>("");
    }

    CGIResponse::Handle r(pool);
    fast_bbs_command_handler<CGIResponse>(&r, config, path_info);
}

void init_env(apr_pool_t *pool, int argc, const char * const *argv)
{
    char *request_method;
    char *request_uri;
    char *path_info;

    if (apr_env_get(&request_method, "REQUEST_METHOD", pool) != APR_SUCCESS) {
        apr_env_set("REQUEST_METHOD", "GET", pool);
    }

    if (apr_env_get(&request_uri, "REQUEST_URI", pool) != APR_SUCCESS) {
        if (argc > 1) {
            apr_env_set("REQUEST_URI", argv[1], pool);
        } else {
            apr_env_set("REQUEST_URI", "http://www.example.com/bbs/", pool);
        }
    }

    if (apr_env_get(&path_info, "PATH_INFO", pool) != APR_SUCCESS) {
        if (argc > 2) {
            apr_env_set("PATH_INFO", argv[2], pool);
        } else {
            apr_env_set("PATH_INFO", "/", pool);
        }
    }
}

int main(int argc, const char * const *argv)
{
    apr_pool_t *pool;

    apr_app_initialize(&argc, &argv, NULL);
    apr_pool_create(&pool, NULL);

    try {
        init_atomic(pool);
        init_env(pool, argc, argv);

        bbs_main(pool);
    } catch(const char *message) {
        cout << "Content-type: text/plain\r\n\r\n";
        cerr << "Error: " << message << endl;

        logger.error(__FILE__, __LINE__, NULL, "[exception] %s", message);

        apr_terminate();

        return EXIT_FAILURE;
    }

    apr_terminate();

    return EXIT_SUCCESS;
}

// Local Variables:
// mode: c++
// coding: utf-8-dos
// End:

