using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace FastBBSConfig
{
    class ApacheConfigCreator
    {
        public static string create(BBSConfig bbsConfig)
        {
            StringBuilder buffer = new StringBuilder();

            buffer.AppendFormat("#### mod_fast_bbs ###################################################\r\n");

            buffer.AppendFormat("LoadFile \"{0}\"\r\n",
                Path.Combine(bbsConfig.imagemagickPath, "CORE_RL_Magick++_.dll"));
            buffer.AppendFormat("LoadModule fast_bbs_module \"{0}\"\r\n",
                bbsConfig.modulePath);

            buffer.AppendFormat("<Location {0}>\r\n",
                bbsConfig.path);
            buffer.AppendFormat("    SetHandler fast_bbs\r\n");
            buffer.AppendFormat("</Location>\r\n");

            buffer.AppendFormat("FastBBSBaseUrl                \"{0}\"\r\n",
                bbsConfig.baseUrl);

            buffer.AppendFormat("FastBBSDataDirectory          \"{0}\"\r\n",
                bbsConfig.dataDirPath);
            buffer.AppendFormat("FastBBSFileDirectory          \"{0}\"\r\n",
                bbsConfig.fileDirPath);
            buffer.AppendFormat("FastBBSTempDirectory          \"{0}\"\r\n",
                bbsConfig.tempDirPath);

            buffer.AppendFormat("FastBBSIndexViewTemplate      \"{0}\"\r\n",
                bbsConfig.indexTmplPath);
            buffer.AppendFormat("FastBBSCommentViewTemplate    \"{0}\"\r\n",
                bbsConfig.commentTmplPath);
            buffer.AppendFormat("FastBBSThreadViewTemplate     \"{0}\"\r\n",
                bbsConfig.threadTmplPath);
            buffer.AppendFormat("FastBBSPostThreadViewTemplate \"{0}\"\r\n",
                bbsConfig.postThreadTmplPath);

            appendAccess(buffer, bbsConfig.imageDirPath);
            appendAccess(buffer, bbsConfig.stylesheetDirPath);
            appendAccess(buffer, bbsConfig.javascriptDirPath);
                
            buffer.AppendFormat("Alias /bbs_img                \"{0}\"\r\n",
                bbsConfig.imageDirPath);
            buffer.AppendFormat("Alias /bbs_css                \"{0}\"\r\n",
                bbsConfig.stylesheetDirPath);
            buffer.AppendFormat("Alias /bbs_js                 \"{0}\"\r\n",
                bbsConfig.javascriptDirPath);

            buffer.AppendFormat("#####################################################################\r\n");

            return buffer.ToString();
        }

        private static void appendAccess(StringBuilder buffer, string path)
        {
            buffer.AppendFormat("<Directory \"{0}\">\r\n", path);
            buffer.AppendFormat("    Order Allow,Deny\r\n");
            buffer.AppendFormat("    Allow From All\r\n");
            buffer.AppendFormat("</Directory>\r\n");
        }
    }
}
