dnl Add support for Apache.
AC_DEFUN(AM_PATH_APXS,
[
AC_ARG_WITH(apxs,
[  --with-apxs=PATH        Full path of apxs command [default=apxs]],
[
        AC_MSG_RESULT(using $withval for apxs command)
        APXS_CMD="$withval"
], [
        AC_PATH_PROG(APXS_CMD, apxs, no)
])

if test "$APXS_CMD" = "no"; then
        AC_MSG_ERROR(apxs is required)
fi

dnl Get Apache directories and flags.
APACHE_CFLAGS=`"$APXS_CMD" -q CFLAGS`
APACHE_INCLUDEDIR=`"$APXS_CMD" -q INCLUDEDIR`
APACHE_LIBEXECDIR=`"$APXS_CMD" -q LIBEXECDIR`
APACHE_LDFLAGS=`"$APXS_CMD" -q LDFLAGS_SHLIB`
AC_SUBST(APACHE_CFLAGS)
AC_SUBST(APACHE_INCLUDEDIR)
AC_SUBST(APACHE_LIBEXECDIR)
AC_SUBST(APACHE_LDFLAGS)
])


dnl Add support for Imlib2.
AC_DEFUN(AM_PATH_IMLIB2,
[
AC_ARG_WITH(imlib2-config,
[  --with-imlib2-config=PATH Full path of imlib2-config command [default=imlib2-config]],
[
        AC_MSG_RESULT(using $withval for imlib2-config command)
        IMLIB2_CONFIG_CMD="$withval"
], [
        AC_PATH_PROG(IMLIB2_CONFIG_CMD, imlib2-config, no)
])

if test "$IMLIB2_CONFIG_CMD" = "no"; then
        AC_MSG_ERROR(imlib2-config is required)
fi

dnl Get Imlib2 flags.
IMLIB2_CFLAGS=`"$IMLIB2_CONFIG_CMD" --cflags`
IMLIB2_LDFLAGS=`"$IMLIB2_CONFIG_CMD" --libs`
AC_SUBST(IMLIB2_CFLAGS)
AC_SUBST(IMLIB2_LDFLAGS)
])
