#include "httpd.h"
#include "http_config.h"
#include "http_protocol.h"
#include "ap_config.h"
#include "http_log.h"

static const char INCLUDE_SIGNATURE[] = "#include ";

/*
 * ǥեȤνargΥѥǻꤷեƤ֤
 */
static char *default_include(request_rec *r, char *arg)
{
    FILE *fp;
    char line[IOBUFSIZE];
    char *content = "";

    fp = ap_pfopen(r->pool, arg, "r");
    if (fp == NULL) {
        ap_log_rerror(APLOG_MARK, APLOG_ERR, r,
                      "can't include: %s", arg);
        return NULL;
    }

    while (fgets(line, sizeof(line), fp) != NULL) {
        content = ap_pstrcat(r->pool, content, line, NULL);
    }
    ap_pfclose(r->pool, fp);
    return content; 
}

/*
 * pluginƥĤ֤plugin϶֥ͭȤؤΥѥ
 * pluginΥɼԤʤɡ顼ξNULL֤
 */
static char *plugin_include(request_rec *r, char *plugin, char *arg)
{
    ap_os_dso_handle_t handle;  /* ͭ饤֥Υʥߥå󥯥ϥɥ */
    /* ͭ饤֥create_content()ؤΥݥ */
    char * (*plugin_func)(request_rec *r, char *arg); 
    char *content;

    /* ͭ饤֥ɤ"create_content"ؿΥݥ󥿤롣*/
    handle = ap_os_dso_load(ap_server_root_relative(r->pool, plugin));
    if (handle == NULL) {
        ap_log_rerror(APLOG_MARK, APLOG_ERR, r,
                      "can't load plugin '%s': %s", plugin, ap_os_dso_error());
        return NULL;
    }
    plugin_func = ap_os_dso_sym(handle, "create_content");
    if (plugin_func == NULL) {
        ap_log_rerror(APLOG_MARK, APLOG_ERR, r,
                      "can't link plugin function 'create_content': %s",
                      ap_os_dso_error());
        return NULL;
    }

    /* plugincreate_content()ؿ¹ */
    content = (*plugin_func)(r, arg);
    /* plugin򥢥 */
    ap_os_dso_unload(handle);

    return content;
}

/*
 * ؼɤ˽äƥƥĤ
 * "#include TYPE ARG"
 */
static char *include_content(request_rec *r, char *src)
{
    char *tail, *type, *arg;
    char *line = ap_pstrdup(r->pool, src);

    /* βԤ */
    tail = strrchr(line, '\n');
    if (tail != NULL)
        *tail = '\0';

    /* ؼɤˡȰ */
    /* #include TYPE ARG                          */
    (void)ap_getword_white_nc(r->pool, &line);
    type = ap_getword_conf_nc(r->pool, &line);
    arg  = ap_getword_conf_nc(r->pool, &line);

    if (strcmp(type, "file") == 0) {
        /* "file"ξ¢ǥեȽ*/
	/* argΥѥΥեƤ֤           */
        return default_include(r, arg); 
    }
    else {
        /* typepluginƥĤ֤ */
        return plugin_include(r, type, arg);
    }
}

static int insert_handler(request_rec *r)
{
    FILE *fp;
    char line[IOBUFSIZE];

    if (r->finfo.st_mode == 0) {
        ap_log_rerror(APLOG_MARK, APLOG_ERR, r,
                      "File does not exists: %s", r->filename);
        return HTTP_NOT_FOUND;
    }

    fp = ap_pfopen(r->pool, r->filename, "r");
    if (fp == NULL) {
        ap_log_rerror(APLOG_MARK, APLOG_ERR, r,
                      "file parmissions deny server access: %s", r->filename);
        return FORBIDDEN;
    }
    
    r->content_type = "text/html";      
    ap_send_http_header(r);
    if (r->header_only)
        return OK;

    while (fgets(line, sizeof(line), fp) != NULL) {
        /* ؼɤִƽ */
        if (strncmp(line, INCLUDE_SIGNATURE, strlen(INCLUDE_SIGNATURE)) == 0) {
            char *new_line;
	    new_line = include_content(r, line);
            if (new_line != NULL)
                ap_rputs(new_line, r);
            continue;
        }

	/* ؼɤ̵ԤϤΤޤ޽ */
        ap_rputs(line, r);
    }
    ap_pfclose(r->pool, fp);
    return OK;
}

static const handler_rec insert_handlers[] = { 
    { "insert", insert_handler }, 
    { NULL, NULL }
};

/* Dispatch list for API hooks */
module MODULE_VAR_EXPORT insert_module = {
    STANDARD_MODULE_STUFF, 
    NULL,                  /* module initializer                  */
    NULL,                  /* create per-dir    config structures */
    NULL,                  /* merge  per-dir    config structures */
    NULL,                  /* create per-server config structures */
    NULL,                  /* merge  per-server config structures */
    NULL,                  /* table of config file commands       */
    insert_handlers,       /* [#8] MIME-typed-dispatched handlers */
    NULL,                  /* [#1] URI to filename translation    */
    NULL,                  /* [#4] validate user id from request  */
    NULL,                  /* [#5] check if the user is ok _here_ */
    NULL,                  /* [#3] check access by host address   */
    NULL,                  /* [#6] determine MIME type            */
    NULL,                  /* [#7] pre-run fixups                 */
    NULL,                  /* [#9] log a transaction              */
    NULL,                  /* [#2] header parser                  */
    NULL,                  /* child_init                          */
    NULL,                  /* child_exit                          */
    NULL                   /* [#0] post read-request              */
#ifdef EAPI
   ,NULL,                  /* EAPI: add_module                    */ 
    NULL,                  /* EAPI: remove_module                 */
    NULL,                  /* EAPI: rewrite_command               */
    NULL                   /* EAPI: new_connection                */
#endif
};

